/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.hadoop;

import java.time.Clock;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUserUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUserUtils.class);

    public static boolean isProxyUser(UserGroupInformation ugi) {
        return ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY;
    }

    public static boolean hasUserKerberosAuthMethod(UserGroupInformation ugi) {
        return UserGroupInformation.isSecurityEnabled() && ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.KERBEROS;
    }

    public static long getIssueDate(Clock clock, String tokenKind, AbstractDelegationTokenIdentifier identifier) {
        long now = clock.millis();
        long issueDate = identifier.getIssueDate();
        if (issueDate > now) {
            LOG.warn("Token {} has set up issue date later than current time. (provided: {} / current timestamp: {}) Please make sure clocks are in sync between machines. If the issue is not a clock mismatch, consult token implementor to check whether issue date is valid.", new Object[]{tokenKind, issueDate, now});
            return issueDate;
        }
        if (issueDate > 0L) {
            return issueDate;
        }
        LOG.warn("Token {} has not set up issue date properly. (provided: {}) Using current timestamp ({}) as issue date instead. Consult token implementor to fix the behavior.", new Object[]{tokenKind, issueDate, now});
        return now;
    }
}

