/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class ClientOptions {
    public static final ConfigOption<Duration> CLIENT_TIMEOUT = ConfigOptions.key("client.timeout").durationType().defaultValue(Duration.ofSeconds(60L)).withDeprecatedKeys("akka.client.timeout").withDescription("Timeout on the client side.");
    public static final ConfigOption<Duration> CLIENT_RETRY_PERIOD = ConfigOptions.key("client.retry-period").durationType().defaultValue(Duration.ofMillis(2000L)).withDescription("The interval (in ms) between consecutive retries of failed attempts to execute commands through the CLI or Flink's clients, wherever retry is supported (default 2sec).");
    public static final ConfigOption<Long> CLIENT_HEARTBEAT_TIMEOUT = ConfigOptions.key("client.heartbeat.timeout").longType().defaultValue(180000L).withDescription(Description.builder().text("Cancel the job if the dispatcher hasn't received the client's heartbeat after timeout when '%s' and '%s' are both true.", TextElement.text(DeploymentOptions.ATTACHED.key()), TextElement.text(DeploymentOptions.SHUTDOWN_IF_ATTACHED.key())).build());
    public static final ConfigOption<Long> CLIENT_HEARTBEAT_INTERVAL = ConfigOptions.key("client.heartbeat.interval").longType().defaultValue(30000L).withDescription(Description.builder().text("Time interval for job client to report its heartbeat when '%s' and '%s' are both true. Cancel the job if timeout configured by '%s'.", TextElement.text(DeploymentOptions.ATTACHED.key()), TextElement.text(DeploymentOptions.SHUTDOWN_IF_ATTACHED.key()), TextElement.text(CLIENT_HEARTBEAT_TIMEOUT.key())).build());
}

