/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.vitess;

import io.debezium.connector.vitess.VitessConnector;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.flink.cdc.connectors.vitess.VitessValidator;
import org.apache.flink.cdc.connectors.vitess.config.SchemaAdjustmentMode;
import org.apache.flink.cdc.connectors.vitess.config.TabletType;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.cdc.debezium.DebeziumSourceFunction;
import org.apache.flink.util.Preconditions;

public class VitessSource {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private String pluginName = "decoderbufs";
        private String name = "flink";
        private int port = 15991;
        private String hostname;
        private String keyspace;
        private String username;
        private String password;
        private TabletType tabletType = TabletType.RDONLY;
        private String shard;
        private String gtid = "current";
        private Boolean stopOnReshard = false;
        private Boolean tombstonesOnDelete = true;
        private String[] messageKeyColumns;
        private SchemaAdjustmentMode schemaNameAdjustmentMode = SchemaAdjustmentMode.NONE;
        private String[] tableIncludeList;
        private String[] tableExcludeList;
        private String[] columnIncludeList;
        private String[] columnExcludeList;
        private Properties dbzProperties;
        private DebeziumDeserializationSchema<T> deserializer;

        public Builder<T> decodingPluginName(String name) {
            this.pluginName = name;
            return this;
        }

        public Builder<T> hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> keyspace(String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public Builder<T> shard(String shard) {
            this.shard = shard;
            return this;
        }

        public Builder<T> gtid(String gtid) {
            this.gtid = gtid;
            return this;
        }

        public Builder<T> stopOnReshard(Boolean stopOnReshard) {
            this.stopOnReshard = stopOnReshard;
            return this;
        }

        public Builder<T> tombstonesOnDelete(Boolean tombstonesOnDelete) {
            this.tombstonesOnDelete = tombstonesOnDelete;
            return this;
        }

        public Builder<T> messageKeyColumns(String[] messageKeyColumns) {
            this.messageKeyColumns = messageKeyColumns;
            return this;
        }

        public Builder<T> schemaNameAdjustmentMode(SchemaAdjustmentMode schemaNameAdjustmentMode) {
            this.schemaNameAdjustmentMode = schemaNameAdjustmentMode;
            return this;
        }

        public Builder<T> tabletType(TabletType tabletType) {
            this.tabletType = tabletType;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> tableIncludeList(String ... tableIncludeList) {
            this.tableIncludeList = tableIncludeList;
            return this;
        }

        public Builder<T> tableExcludeList(String ... tableExcludeList) {
            this.tableExcludeList = tableExcludeList;
            return this;
        }

        public Builder<T> columnIncludeList(String ... columnIncludeList) {
            this.columnIncludeList = columnIncludeList;
            return this;
        }

        public Builder<T> columnExcludeList(String ... columnExcludeList) {
            this.columnExcludeList = columnExcludeList;
            return this;
        }

        public Builder<T> debeziumProperties(Properties properties) {
            this.dbzProperties = properties;
            return this;
        }

        public Builder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public DebeziumSourceFunction<T> build() {
            Properties props = new Properties();
            props.setProperty("connector.class", VitessConnector.class.getCanonicalName());
            props.setProperty("plugin.name", this.pluginName);
            props.setProperty("name", this.name);
            props.setProperty("database.server.name", "vitess_cdc_source");
            props.setProperty("database.hostname", (String)Preconditions.checkNotNull((Object)this.hostname));
            props.setProperty("database.port", String.valueOf(this.port));
            props.setProperty("vitess.keyspace", (String)Preconditions.checkNotNull((Object)this.keyspace));
            props.setProperty("vitess.tablet.type", this.tabletType.name());
            if (this.username != null) {
                props.setProperty("vitess.database.user", this.username);
            }
            if (this.password != null) {
                props.setProperty("vitess.database.password", this.password);
            }
            if (this.shard != null) {
                props.setProperty("vitess.shard", this.shard);
            }
            props.setProperty("vitess.gtid", (String)Preconditions.checkNotNull((Object)this.gtid));
            if (this.messageKeyColumns != null) {
                props.setProperty("message.key.columns", String.join((CharSequence)",", this.messageKeyColumns));
            }
            props.setProperty("schema.name.adjustment.mode", this.schemaNameAdjustmentMode.name().toLowerCase());
            props.setProperty("vitess.stop_on_reshard", this.stopOnReshard.toString());
            props.setProperty("tombstones.on.delete", this.tombstonesOnDelete.toString());
            props.setProperty("tasks.max", "1");
            if (this.tableIncludeList != null) {
                props.setProperty("table.include.list", String.join((CharSequence)",", this.tableIncludeList));
            }
            if (this.tableExcludeList != null) {
                props.setProperty("table.exclude.list", String.join((CharSequence)",", this.tableExcludeList));
            }
            if (this.columnIncludeList != null) {
                props.setProperty("column.include.list", String.join((CharSequence)",", this.columnIncludeList));
            }
            if (this.columnExcludeList != null) {
                props.setProperty("column.exclude.list", String.join((CharSequence)",", this.columnExcludeList));
            }
            if (this.dbzProperties != null) {
                this.dbzProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)props::put));
            }
            return new DebeziumSourceFunction<T>(this.deserializer, props, null, new VitessValidator(props));
        }
    }
}

