/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client;

import io.vitess.proto.Vtrpc;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class Context {
    private static final Context DEFAULT_CONTEXT = new Context();
    private Instant deadline;
    private Vtrpc.CallerID callerId;

    private Context() {
    }

    private Context(Instant deadline, Vtrpc.CallerID callerId) {
        this.deadline = deadline;
        this.callerId = callerId;
    }

    public static Context getDefault() {
        return DEFAULT_CONTEXT;
    }

    public Context withDeadline(Instant deadline) {
        if (this.deadline != null && this.deadline.isBefore(deadline)) {
            return this;
        }
        return new Context(deadline, this.callerId);
    }

    public Context withDeadlineAfter(Duration duration) {
        return this.withDeadline(Instant.now().plus(duration));
    }

    public Context withCallerId(Vtrpc.CallerID callerId) {
        if (this.callerId != null && this.callerId.equals(callerId)) {
            return this;
        }
        return new Context(this.deadline, callerId);
    }

    @Nullable
    public Instant getDeadline() {
        return this.deadline;
    }

    @Nullable
    public Duration getTimeout() {
        if (this.deadline == null) {
            return null;
        }
        return new Duration(null, this.deadline);
    }

    @Nullable
    public Vtrpc.CallerID getCallerId() {
        return this.callerId;
    }
}

