/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.metrics;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.data.Envelope;
import io.debezium.pipeline.ConnectorEvent;
import io.debezium.pipeline.meters.ConnectionMeter;
import io.debezium.pipeline.meters.StreamingMeter;
import io.debezium.pipeline.metrics.PipelineMetrics;
import io.debezium.pipeline.metrics.StreamingChangeEventSourceMetrics;
import io.debezium.pipeline.metrics.StreamingChangeEventSourceMetricsMXBean;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionId;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;

@ThreadSafe
public class DefaultStreamingChangeEventSourceMetrics<P extends Partition>
extends PipelineMetrics<P>
implements StreamingChangeEventSourceMetrics<P>,
StreamingChangeEventSourceMetricsMXBean {
    private final ConnectionMeter connectionMeter;
    private final StreamingMeter streamingMeter;

    public <T extends CdcSourceTaskContext> DefaultStreamingChangeEventSourceMetrics(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider) {
        super(taskContext, "streaming", changeEventQueueMetrics, metadataProvider);
        this.streamingMeter = new StreamingMeter(taskContext, metadataProvider);
        this.connectionMeter = new ConnectionMeter();
    }

    public <T extends CdcSourceTaskContext> DefaultStreamingChangeEventSourceMetrics(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, Map<String, String> tags) {
        super(taskContext, changeEventQueueMetrics, metadataProvider, tags);
        this.streamingMeter = new StreamingMeter(taskContext, metadataProvider);
        this.connectionMeter = new ConnectionMeter();
    }

    @Override
    public boolean isConnected() {
        return this.connectionMeter.isConnected();
    }

    @Override
    @Deprecated
    public String[] getMonitoredTables() {
        return this.streamingMeter.getCapturedTables();
    }

    @Override
    public String[] getCapturedTables() {
        return this.streamingMeter.getCapturedTables();
    }

    @Override
    public void connected(boolean connected) {
        this.connectionMeter.connected(connected);
    }

    @Override
    public Map<String, String> getSourceEventPosition() {
        return this.streamingMeter.getSourceEventPosition();
    }

    @Override
    public long getMilliSecondsBehindSource() {
        return this.streamingMeter.getMilliSecondsBehindSource();
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.streamingMeter.getNumberOfCommittedTransactions();
    }

    @Override
    public void onEvent(P partition, DataCollectionId source, OffsetContext offset, Object key, Struct value, Envelope.Operation operation) {
        super.onEvent(partition, source, offset, key, value, operation);
        this.streamingMeter.onEvent(source, offset, key, value);
    }

    @Override
    public void onConnectorEvent(P partition, ConnectorEvent event) {
    }

    @Override
    public String getLastTransactionId() {
        return this.streamingMeter.getLastTransactionId();
    }

    @Override
    public void reset() {
        super.reset();
        this.streamingMeter.reset();
        this.connectionMeter.reset();
    }
}

