/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerValidationResult;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;

public class OAuthBearerUnsecuredJws
implements OAuthBearerToken {
    private final String compactSerialization;
    private final List<String> splits;
    private final Map<String, Object> header;
    private final String principalClaimName;
    private final String scopeClaimName;
    private final Map<String, Object> claims;
    private final Set<String> scope;
    private final long lifetime;
    private final String principalName;
    private final Long startTimeMs;

    public OAuthBearerUnsecuredJws(String compactSerialization, String principalClaimName, String scopeClaimName) throws OAuthBearerIllegalTokenException {
        this.compactSerialization = Objects.requireNonNull(compactSerialization);
        if (compactSerialization.contains("..")) {
            throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure("Malformed compact serialization contains '..'"));
        }
        this.splits = this.extractCompactSerializationSplits();
        this.header = OAuthBearerUnsecuredJws.toMap(this.splits().get(0));
        String claimsSplit = this.splits.get(1);
        this.claims = OAuthBearerUnsecuredJws.toMap(claimsSplit);
        String alg = Objects.requireNonNull(this.header().get("alg"), "JWS header must have an Algorithm value").toString();
        if (!"none".equals(alg)) {
            throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure("Unsecured JWS must have 'none' for an algorithm"));
        }
        String digitalSignatureSplit = this.splits.get(2);
        if (!digitalSignatureSplit.isEmpty()) {
            throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure("Unsecured JWS must not contain a digital signature"));
        }
        this.principalClaimName = Objects.requireNonNull(principalClaimName).trim();
        if (this.principalClaimName.isEmpty()) {
            throw new IllegalArgumentException("Must specify a non-blank principal claim name");
        }
        this.scopeClaimName = Objects.requireNonNull(scopeClaimName).trim();
        if (this.scopeClaimName.isEmpty()) {
            throw new IllegalArgumentException("Must specify a non-blank scope claim name");
        }
        this.scope = this.calculateScope();
        Number expirationTimeSeconds = this.expirationTime();
        if (expirationTimeSeconds == null) {
            throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure("No expiration time in JWT"));
        }
        this.lifetime = OAuthBearerUnsecuredJws.convertClaimTimeInSecondsToMs(expirationTimeSeconds);
        String principalName = this.claim(this.principalClaimName, String.class);
        if (Utils.isBlank(principalName)) {
            throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure("No principal name in JWT claim: " + this.principalClaimName));
        }
        this.principalName = principalName;
        this.startTimeMs = this.calculateStartTimeMs();
    }

    @Override
    public String value() {
        return this.compactSerialization;
    }

    public List<String> splits() {
        return this.splits;
    }

    public Map<String, Object> header() {
        return this.header;
    }

    @Override
    public String principalName() {
        return this.principalName;
    }

    @Override
    public Long startTimeMs() {
        return this.startTimeMs;
    }

    @Override
    public long lifetimeMs() {
        return this.lifetime;
    }

    @Override
    public Set<String> scope() throws OAuthBearerIllegalTokenException {
        return this.scope;
    }

    public Map<String, Object> claims() {
        return this.claims;
    }

    public String principalClaimName() {
        return this.principalClaimName;
    }

    public String scopeClaimName() {
        return this.scopeClaimName;
    }

    public boolean isClaimType(String claimName, Class<?> type) {
        Object value = this.rawClaim(claimName);
        Objects.requireNonNull(type);
        if (value == null) {
            return false;
        }
        if (type == String.class && value instanceof String) {
            return true;
        }
        if (type == Number.class && value instanceof Number) {
            return true;
        }
        return type == List.class && value instanceof List;
    }

    public <T> T claim(String claimName, Class<T> type) throws OAuthBearerIllegalTokenException {
        Object value = this.rawClaim(claimName);
        try {
            return Objects.requireNonNull(type).cast(value);
        }
        catch (ClassCastException e) {
            throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure(String.format("The '%s' claim was not of type %s: %s", claimName, type.getSimpleName(), value.getClass().getSimpleName())));
        }
    }

    public Object rawClaim(String claimName) {
        return this.claims().get(Objects.requireNonNull(claimName));
    }

    public Number expirationTime() throws OAuthBearerIllegalTokenException {
        return this.claim("exp", Number.class);
    }

    public Number issuedAt() throws OAuthBearerIllegalTokenException {
        return this.claim("iat", Number.class);
    }

    public String subject() throws OAuthBearerIllegalTokenException {
        return this.claim("sub", String.class);
    }

    public static Map<String, Object> toMap(String split) throws OAuthBearerIllegalTokenException {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        try {
            byte[] decode = Base64.getDecoder().decode(split);
            JsonNode jsonNode = new ObjectMapper().readTree(decode);
            if (jsonNode == null) {
                throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure("malformed JSON"));
            }
            Iterator<Map.Entry<String, JsonNode>> iterator = jsonNode.fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                retval.put(entry.getKey(), OAuthBearerUnsecuredJws.convert(entry.getValue()));
            }
            return Collections.unmodifiableMap(retval);
        }
        catch (IllegalArgumentException e) {
            throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure("malformed Base64 URL encoded value"));
        }
        catch (IOException e) {
            throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure("malformed JSON"));
        }
    }

    private List<String> extractCompactSerializationSplits() {
        ArrayList<String> tmpSplits = new ArrayList<String>(Arrays.asList(this.compactSerialization.split("\\.")));
        if (this.compactSerialization.endsWith(".")) {
            tmpSplits.add("");
        }
        if (tmpSplits.size() != 3) {
            throw new OAuthBearerIllegalTokenException(OAuthBearerValidationResult.newFailure("Unsecured JWS compact serializations must have 3 dot-separated Base64URL-encoded values"));
        }
        return Collections.unmodifiableList(tmpSplits);
    }

    private static Object convert(JsonNode value) {
        if (value.isArray()) {
            ArrayList<String> retvalList = new ArrayList<String>();
            for (JsonNode arrayElement : value) {
                retvalList.add(arrayElement.asText());
            }
            return retvalList;
        }
        return value.getNodeType() == JsonNodeType.NUMBER ? value.numberValue() : value.asText();
    }

    private Long calculateStartTimeMs() throws OAuthBearerIllegalTokenException {
        Number issuedAtSeconds = this.claim("iat", Number.class);
        return issuedAtSeconds == null ? null : Long.valueOf(OAuthBearerUnsecuredJws.convertClaimTimeInSecondsToMs(issuedAtSeconds));
    }

    private static long convertClaimTimeInSecondsToMs(Number claimValue) {
        return Math.round(claimValue.doubleValue() * 1000.0);
    }

    private Set<String> calculateScope() {
        String scopeClaimName = this.scopeClaimName();
        if (this.isClaimType(scopeClaimName, String.class)) {
            String scopeClaimValue = this.claim(scopeClaimName, String.class);
            if (Utils.isBlank(scopeClaimValue)) {
                return Collections.emptySet();
            }
            HashSet<String> retval = new HashSet<String>();
            retval.add(scopeClaimValue.trim());
            return Collections.unmodifiableSet(retval);
        }
        List scopeClaimValue = this.claim(scopeClaimName, List.class);
        if (scopeClaimValue == null || scopeClaimValue.isEmpty()) {
            return Collections.emptySet();
        }
        List stringList = scopeClaimValue;
        HashSet<String> retval = new HashSet<String>();
        for (String scope : stringList) {
            if (Utils.isBlank(scope)) continue;
            retval.add(scope.trim());
        }
        return Collections.unmodifiableSet(retval);
    }
}

