/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.flink.cdc.common.text.ParsingException;
import org.apache.flink.cdc.common.text.TokenStream;

public class Predicates {
    public static <T> Predicate<T> includes(String regexPatterns, Function<T, String> conversion) {
        Set<Pattern> patterns = Predicates.setOfRegex(regexPatterns, 2);
        return Predicates.includedInPatterns(patterns, conversion);
    }

    protected static <T> Predicate<T> includedInPatterns(Collection<Pattern> patterns, Function<T, String> conversion) {
        return t -> Predicates.matchedByPattern(patterns, conversion).apply(t).isPresent();
    }

    public static Predicate<String> includes(String regexPatterns) {
        return Predicates.includes(regexPatterns, str -> str);
    }

    public static Set<Pattern> setOfRegex(String input, int regexFlags) {
        return Predicates.setOf(input, RegExSplitterByComma::split, str -> Pattern.compile(str, regexFlags));
    }

    public static <T> Set<T> setOf(String input, Function<String, String[]> splitter, Function<String, T> factory) {
        if (input == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> matches = new LinkedHashSet<T>();
        for (String item : splitter.apply(input)) {
            T obj = factory.apply(item);
            if (obj == null) continue;
            matches.add(obj);
        }
        return matches;
    }

    public static <T> List<T> listOf(String input, Function<String, String[]> splitter, Function<String, T> factory) {
        if (input == null) {
            return Collections.emptyList();
        }
        LinkedList<T> matches = new LinkedList<T>();
        for (String item : splitter.apply(input)) {
            T obj = factory.apply(item);
            if (obj == null) continue;
            matches.add(obj);
        }
        return matches;
    }

    protected static <T> Function<T, Optional<Pattern>> matchedByPattern(Collection<Pattern> patterns, Function<T, String> conversion) {
        return t -> {
            String str = (String)conversion.apply(t);
            if (str != null) {
                for (Pattern p : patterns) {
                    if (!p.matcher(str).matches()) continue;
                    return Optional.of(p);
                }
            }
            return Optional.empty();
        };
    }

    public static class RegExSplitterByDot
    implements TokenStream.Tokenizer {
        public static String[] split(String identifier) {
            TokenStream stream = new TokenStream(identifier, new RegExSplitterByDot(), true);
            stream.start();
            ArrayList<String> parts = new ArrayList<String>();
            while (stream.hasNext()) {
                String part = stream.consume();
                if (part.isEmpty()) continue;
                parts.add(part.trim().replace("\\.", "."));
            }
            return parts.toArray(new String[0]);
        }

        @Override
        public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
            int tokenStart = 0;
            while (input.hasNext()) {
                char c = input.next();
                if (c == '\\') {
                    if (!input.hasNext()) {
                        throw new ParsingException(input.position(input.index()), "Unterminated escape sequence at the end of the string");
                    }
                    input.next();
                    continue;
                }
                if (c != '.') continue;
                tokens.addToken(input.position(tokenStart), tokenStart, input.index());
                tokenStart = input.index() + 1;
            }
            tokens.addToken(input.position(tokenStart), tokenStart, input.index() + 1);
        }
    }

    public static class RegExSplitterByComma
    implements TokenStream.Tokenizer {
        public static String[] split(String identifier) {
            TokenStream stream = new TokenStream(identifier, new RegExSplitterByComma(), true);
            stream.start();
            ArrayList<String> parts = new ArrayList<String>();
            while (stream.hasNext()) {
                String part = stream.consume();
                if (part.isEmpty()) continue;
                parts.add(part.trim().replace("\\,", ","));
            }
            return parts.toArray(new String[0]);
        }

        @Override
        public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
            int tokenStart = 0;
            while (input.hasNext()) {
                char c = input.next();
                if (c == '\\') {
                    if (!input.hasNext()) {
                        throw new ParsingException(input.position(input.index()), "Unterminated escape sequence at the end of the string");
                    }
                    input.next();
                    continue;
                }
                if (c != ',') continue;
                tokens.addToken(input.position(tokenStart), tokenStart, input.index());
                tokenStart = input.index() + 1;
            }
            tokens.addToken(input.position(tokenStart), tokenStart, input.index() + 1);
        }
    }
}

