/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.cdc.common.types.DataTypeVisitor;

@PublicEvolving
public final class LocalZonedTimestampType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_PRECISION = 0;
    public static final int MAX_PRECISION = 9;
    public static final int DEFAULT_PRECISION = 6;
    private static final String FORMAT = "TIMESTAMP(%d) WITH LOCAL TIME ZONE";
    private static final String SUMMARY_FORMAT = "TIMESTAMP_LTZ(%d)";
    private final int precision;

    public LocalZonedTimestampType(boolean isNullable, int precision) {
        super(isNullable, DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        if (precision < 0 || precision > 9) {
            throw new IllegalArgumentException(String.format("Timestamp with local time zone precision must be between %d and %d (both inclusive).", 0, 9));
        }
        this.precision = precision;
    }

    public LocalZonedTimestampType(int precision) {
        this(true, precision);
    }

    public LocalZonedTimestampType() {
        this(6);
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new LocalZonedTimestampType(isNullable, this.precision);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.precision);
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(SUMMARY_FORMAT, this.precision);
    }

    @Override
    public List<DataType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalZonedTimestampType that = (LocalZonedTimestampType)o;
        return this.precision == that.precision;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision);
    }
}

