/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client.grpc;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.CallCredentials;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.Metadata;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.Status;

public class StaticAuthCredentials
extends CallCredentials {
    private static final Metadata.Key<String> USERNAME = Metadata.Key.of("username", Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> PASSWORD = Metadata.Key.of("password", Metadata.ASCII_STRING_MARSHALLER);
    private final String username;
    private final String password;

    public StaticAuthCredentials(String username, String password) {
        this.username = Objects.requireNonNull(username);
        this.password = Objects.requireNonNull(password);
    }

    @Override
    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier applier) {
        executor.execute(() -> {
            try {
                Metadata headers = new Metadata();
                headers.put(USERNAME, this.username);
                headers.put(PASSWORD, this.password);
                applier.apply(headers);
            }
            catch (Throwable exc) {
                applier.fail(Status.UNAUTHENTICATED.withCause(exc));
            }
        });
    }

    @Override
    public void thisUsesUnstableApi() {
    }
}

