/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.Configuration;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.schema.DataCollectionFilters;
import java.util.function.Predicate;

public class RelationalTableFilters
implements DataCollectionFilters {
    private final Tables.TableFilter eligibleTableFilter;
    private Tables.TableFilter tableFilter;
    private final Predicate<String> databaseFilter;
    private final String excludeColumns;
    private final Tables.TableFilter schemaSnapshotFilter;

    public RelationalTableFilters(Configuration config, Tables.TableFilter systemTablesFilter, Selectors.TableIdToStringMapper tableIdMapper) {
        Predicate<TableId> eligibleSchemaPredicate;
        Selectors.TableSelectionPredicateBuilder eligibleTables = Selectors.tableSelector().includeDatabases(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.DATABASE_INCLUDE_LIST, RelationalDatabaseConnectorConfig.DATABASE_WHITELIST)).excludeDatabases(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.DATABASE_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.DATABASE_BLACKLIST)).includeSchemas(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.SCHEMA_INCLUDE_LIST, RelationalDatabaseConnectorConfig.SCHEMA_WHITELIST)).excludeSchemas(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.SCHEMA_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.SCHEMA_BLACKLIST));
        Predicate<TableId> eligibleTablePredicate = eligibleTables.build();
        Predicate<TableId> finalEligibleTablePredicate = config.getBoolean(RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN) ? eligibleTablePredicate.and(systemTablesFilter::isIncluded) : eligibleTablePredicate;
        this.eligibleTableFilter = finalEligibleTablePredicate::test;
        Predicate<TableId> tablePredicate = eligibleTables.includeTables(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_WHITELIST), tableIdMapper).excludeTables(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_BLACKLIST), tableIdMapper).build();
        Predicate<TableId> finalTablePredicate = config.getBoolean(RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN) ? tablePredicate.and(systemTablesFilter::isIncluded) : tablePredicate;
        this.tableFilter = finalTablePredicate::test;
        this.databaseFilter = Selectors.databaseSelector().includeDatabases(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.DATABASE_INCLUDE_LIST, RelationalDatabaseConnectorConfig.DATABASE_WHITELIST)).excludeDatabases(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.DATABASE_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.DATABASE_BLACKLIST)).build();
        Predicate<TableId> predicate = config.getBoolean(RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN) ? systemTablesFilter::isIncluded : (eligibleSchemaPredicate = x -> true);
        this.schemaSnapshotFilter = config.getBoolean(DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL) ? eligibleSchemaPredicate.and(this.tableFilter::isIncluded)::test : eligibleSchemaPredicate::test;
        this.excludeColumns = config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.COLUMN_BLACKLIST);
    }

    public Tables.TableFilter dataCollectionFilter() {
        return this.tableFilter;
    }

    public Tables.TableFilter eligibleDataCollectionFilter() {
        return this.eligibleTableFilter;
    }

    public Tables.TableFilter eligibleForSchemaDataCollectionFilter() {
        return this.schemaSnapshotFilter;
    }

    public Predicate<String> databaseFilter() {
        return this.databaseFilter;
    }

    public String getExcludeColumns() {
        return this.excludeColumns;
    }

    public void setDataCollectionFilters(Tables.TableFilter tableFilter) {
        this.tableFilter = tableFilter;
    }
}

