/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.partitioning;

import java.util.Objects;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.Event;

@Internal
public class PartitioningEvent
implements Event {
    private final Event payload;
    private final int sourcePartition;
    private final int targetPartition;

    public static PartitioningEvent ofRegular(Event payload, int targetPartition) {
        return new PartitioningEvent(payload, -1, targetPartition);
    }

    public static PartitioningEvent ofDistributed(Event payload, int sourcePartition, int targetPartition) {
        return new PartitioningEvent(payload, sourcePartition, targetPartition);
    }

    private PartitioningEvent(Event payload, int sourcePartition, int targetPartition) {
        this.payload = payload;
        this.sourcePartition = sourcePartition;
        this.targetPartition = targetPartition;
    }

    public Event getPayload() {
        return this.payload;
    }

    public int getSourcePartition() {
        return this.sourcePartition;
    }

    public int getTargetPartition() {
        return this.targetPartition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitioningEvent that = (PartitioningEvent)o;
        return this.sourcePartition == that.sourcePartition && this.targetPartition == that.targetPartition && Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return Objects.hash(this.payload, this.sourcePartition, this.targetPartition);
    }

    public String toString() {
        return "PartitioningEvent{payload=" + this.payload + ", sourcePartition=" + this.sourcePartition + ", targetPartition=" + this.targetPartition + '}';
    }
}

