/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.parser.metadata;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OrdinalReturnTypeInference;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public class TransformSqlReturnTypes {
    public static final SqlReturnTypeInference ROUND_FUNCTION = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            BigDecimal lenVal;
            RelDataType numType = opBinding.getOperandType(0);
            if (numType.getSqlTypeName() != SqlTypeName.DECIMAL) {
                return numType;
            }
            if (opBinding.getOperandCount() == 1) {
                lenVal = BigDecimal.ZERO;
            } else if (opBinding.getOperandCount() == 2) {
                lenVal = this.getArg1Literal(opBinding);
            } else {
                throw new AssertionError();
            }
            if (lenVal == null) {
                return numType;
            }
            int p = numType.getPrecision();
            int s = numType.getScale();
            int r = lenVal.intValueExact();
            DecimalType dt = LogicalTypeMerging.findRoundDecimalType((int)p, (int)s, (int)r);
            return opBinding.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, dt.getPrecision(), dt.getScale());
        }

        private BigDecimal getArg1Literal(SqlOperatorBinding opBinding) {
            try {
                return (BigDecimal)opBinding.getOperandLiteralValue(1, BigDecimal.class);
            }
            catch (Throwable e) {
                return null;
            }
        }
    };
    public static final SqlReturnTypeInference ARG0_VARCHAR_FORCE_NULLABLE = new OrdinalReturnTypeInference(0){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType newType;
            RelDataType type = super.inferReturnType(opBinding);
            switch (type.getSqlTypeName()) {
                case CHAR: {
                    newType = opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, type.getPrecision());
                    break;
                }
                case VARCHAR: {
                    newType = type;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported type: " + type);
                }
            }
            return opBinding.getTypeFactory().createTypeWithNullability(newType, true);
        }
    };
    public static final SqlReturnTypeInference VARCHAR_FORCE_NULLABLE = ReturnTypes.cascade((SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARCHAR), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE});
    public static final SqlReturnTypeInference VARCHAR_NOT_NULL = ReturnTypes.cascade((SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARCHAR), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.TO_NOT_NULLABLE});
    public static final SqlReturnTypeInference ROUND_FUNCTION_NULLABLE = ReturnTypes.cascade((SqlReturnTypeInference)ROUND_FUNCTION, (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.TO_NULLABLE});
    public static final SqlReturnTypeInference IF_NULLABLE = ReturnTypes.cascade((SqlReturnTypeInference)new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            int nOperands = opBinding.getOperandCount();
            ArrayList<RelDataType> types = new ArrayList<RelDataType>();
            for (int i = 1; i < nOperands; ++i) {
                RelDataType type = opBinding.getOperandType(i);
                if (!(SqlTypeUtil.isNumeric((RelDataType)type) || SqlTypeUtil.isCharacter((RelDataType)type) || SqlTypeUtil.isBinary((RelDataType)type))) {
                    return opBinding.getOperandType(1);
                }
                types.add(type);
            }
            return opBinding.getTypeFactory().leastRestrictive(types);
        }
    }, (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.TO_NULLABLE});
    public static final SqlReturnTypeInference NUMERIC_FROM_ARG1_DEFAULT1 = new NumericOrDefaultReturnTypeInference(1, 1);
    public static final SqlReturnTypeInference NUMERIC_FROM_ARG1_DEFAULT1_NULLABLE = ReturnTypes.cascade((SqlReturnTypeInference)NUMERIC_FROM_ARG1_DEFAULT1, (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.TO_NULLABLE});

    private static class NumericOrDefaultReturnTypeInference
    implements SqlReturnTypeInference {
        private int defaultTypeIdx;
        private int startTypeIdx;

        public NumericOrDefaultReturnTypeInference(int defaultTypeIdx) {
            this(defaultTypeIdx, 0);
        }

        public NumericOrDefaultReturnTypeInference(int defaultTypeIdx, int startTypeIdx) {
            this.defaultTypeIdx = defaultTypeIdx;
            this.startTypeIdx = startTypeIdx;
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            int nOperands = opBinding.getOperandCount();
            ArrayList<RelDataType> types = new ArrayList<RelDataType>();
            for (int i = this.startTypeIdx; i < nOperands; ++i) {
                RelDataType type = opBinding.getOperandType(i);
                if (!SqlTypeUtil.isNumeric((RelDataType)type)) {
                    return opBinding.getOperandType(this.defaultTypeIdx);
                }
                types.add(type);
            }
            return opBinding.getTypeFactory().leastRestrictive(types);
        }
    }
}

