/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.parser.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class TransformNumericExceptFirstOperandChecker
implements SqlOperandTypeChecker {
    private int nOperands;

    public TransformNumericExceptFirstOperandChecker(int nOperands) {
        this.nOperands = nOperands;
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        for (int i = 1; i < callBinding.getOperandCount(); ++i) {
            if (SqlTypeUtil.isNumeric((RelDataType)callBinding.getOperandType(i))) continue;
            if (!throwOnFailure) {
                return false;
            }
            throw callBinding.newValidationSignatureError();
        }
        return true;
    }

    public SqlOperandCountRange getOperandCountRange() {
        if (this.nOperands == -1) {
            return SqlOperandCountRanges.any();
        }
        return SqlOperandCountRanges.of((int)this.nOperands);
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        String anyType = "ANY_TYPE";
        String numericType = "NUMERIC_TYPE";
        if (this.nOperands == -1) {
            return SqlUtil.getAliasedSignature((SqlOperator)op, (String)opName, Arrays.asList("ANY_TYPE", "NUMERIC_TYPE", "..."));
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("ANY_TYPE");
        types.addAll(Collections.nCopies(this.nOperands - 1, "NUMERIC_TYPE"));
        return SqlUtil.getAliasedSignature((SqlOperator)op, (String)opName, types);
    }

    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    public boolean isOptional(int i) {
        return false;
    }
}

