/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.util.List;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.utils.SchemaUtils;
import org.apache.flink.cdc.runtime.typeutils.BinaryRecordDataGenerator;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;

public class PostTransformChangeInfo {
    private TableId tableId;
    private Schema preTransformedSchema;
    private Schema postTransformedSchema;
    private RecordData.FieldGetter[] preTransformedFieldGetters;
    private RecordData.FieldGetter[] postTransformedFieldGetters;
    private BinaryRecordDataGenerator recordDataGenerator;

    public PostTransformChangeInfo(TableId tableId, Schema postTransformedSchema, RecordData.FieldGetter[] postTransformedFieldGetters, Schema preTransformedSchema, RecordData.FieldGetter[] preTransformedFieldGetters, BinaryRecordDataGenerator recordDataGenerator) {
        this.tableId = tableId;
        this.postTransformedSchema = postTransformedSchema;
        this.postTransformedFieldGetters = postTransformedFieldGetters;
        this.preTransformedSchema = preTransformedSchema;
        this.preTransformedFieldGetters = preTransformedFieldGetters;
        this.recordDataGenerator = recordDataGenerator;
    }

    public String getName() {
        return this.tableId.identifier();
    }

    public String getTableName() {
        return this.tableId.getTableName();
    }

    public String getSchemaName() {
        return this.tableId.getSchemaName();
    }

    public String getNamespace() {
        return this.tableId.getNamespace();
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public Schema getPostTransformedSchema() {
        return this.postTransformedSchema;
    }

    public Schema getPreTransformedSchema() {
        return this.preTransformedSchema;
    }

    public RecordData.FieldGetter[] getPostTransformedFieldGetters() {
        return this.postTransformedFieldGetters;
    }

    public RecordData.FieldGetter[] getPreTransformedFieldGetters() {
        return this.preTransformedFieldGetters;
    }

    public BinaryRecordDataGenerator getRecordDataGenerator() {
        return this.recordDataGenerator;
    }

    public static PostTransformChangeInfo of(TableId tableId, Schema postTransformedSchema, Schema preTransformedSchema) {
        List<RecordData.FieldGetter> postTransformedFieldGetters = SchemaUtils.createFieldGetters(postTransformedSchema.getColumns());
        List<RecordData.FieldGetter> preTransformedFieldGetters = SchemaUtils.createFieldGetters(preTransformedSchema.getColumns());
        BinaryRecordDataGenerator postTransformedRecordDataGenerator = new BinaryRecordDataGenerator(DataTypeConverter.toRowType(postTransformedSchema.getColumns()));
        return new PostTransformChangeInfo(tableId, postTransformedSchema, postTransformedFieldGetters.toArray(new RecordData.FieldGetter[0]), preTransformedSchema, preTransformedFieldGetters.toArray(new RecordData.FieldGetter[0]), postTransformedRecordDataGenerator);
    }
}

