/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.types.DataTypeFamily;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.cdc.common.types.DataTypeVisitor;
import org.apache.flink.cdc.common.utils.Preconditions;

public abstract class DataType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean isNullable;
    private final DataTypeRoot typeRoot;

    public DataType(boolean isNullable, DataTypeRoot typeRoot) {
        this.isNullable = isNullable;
        this.typeRoot = Preconditions.checkNotNull(typeRoot);
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public DataTypeRoot getTypeRoot() {
        return this.typeRoot;
    }

    public boolean is(DataTypeRoot typeRoot) {
        return this.typeRoot == typeRoot;
    }

    public boolean isAnyOf(DataTypeRoot ... typeRoots) {
        return Arrays.stream(typeRoots).anyMatch(tr -> this.typeRoot == tr);
    }

    public boolean isAnyOf(DataTypeFamily ... typeFamilies) {
        return Arrays.stream(typeFamilies).anyMatch(tf -> this.typeRoot.getFamilies().contains(tf));
    }

    public boolean is(DataTypeFamily family) {
        return this.typeRoot.getFamilies().contains((Object)family);
    }

    public abstract DataType copy(boolean var1);

    public final DataType copy() {
        return this.copy(this.isNullable);
    }

    public abstract String asSerializableString();

    public String asSummaryString() {
        return this.asSerializableString();
    }

    public abstract List<DataType> getChildren();

    public abstract <R> R accept(DataTypeVisitor<R> var1);

    public String toString() {
        return this.asSummaryString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataType that = (DataType)o;
        return this.isNullable == that.isNullable && this.typeRoot == that.typeRoot;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isNullable, this.typeRoot});
    }

    public DataType notNull() {
        return this.copy(false);
    }

    public DataType nullable() {
        return this.copy(true);
    }

    protected String withNullability(String format, Object ... params) {
        if (!this.isNullable) {
            return String.format(format + " NOT NULL", params);
        }
        return String.format(format, params);
    }
}

