/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.util.List;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.utils.SchemaUtils;
import org.apache.flink.cdc.runtime.typeutils.BinaryRecordDataGenerator;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;

public class TableInfo {
    private TableId tableId;
    private Schema schema;
    private RecordData.FieldGetter[] fieldGetters;
    private BinaryRecordDataGenerator recordDataGenerator;

    public TableInfo(TableId tableId, Schema schema, RecordData.FieldGetter[] fieldGetters, BinaryRecordDataGenerator recordDataGenerator) {
        this.tableId = tableId;
        this.schema = schema;
        this.fieldGetters = fieldGetters;
        this.recordDataGenerator = recordDataGenerator;
    }

    public String getName() {
        return this.tableId.identifier();
    }

    public String getTableName() {
        return this.tableId.getTableName();
    }

    public String getSchemaName() {
        return this.tableId.getSchemaName();
    }

    public String getNamespace() {
        return this.tableId.getNamespace();
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public RecordData.FieldGetter[] getFieldGetters() {
        return this.fieldGetters;
    }

    public BinaryRecordDataGenerator getRecordDataGenerator() {
        return this.recordDataGenerator;
    }

    public static TableInfo of(TableId tableId, Schema schema) {
        List<RecordData.FieldGetter> fieldGetters = SchemaUtils.createFieldGetters(schema.getColumns());
        BinaryRecordDataGenerator recordDataGenerator = new BinaryRecordDataGenerator(DataTypeConverter.toRowType(schema.getColumns()));
        return new TableInfo(tableId, schema, fieldGetters.toArray(new RecordData.FieldGetter[0]), recordDataGenerator);
    }
}

