/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema;

import java.time.Duration;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.sink.MetadataApplier;
import org.apache.flink.cdc.runtime.operators.schema.SchemaOperator;
import org.apache.flink.cdc.runtime.operators.schema.coordinator.SchemaRegistryProvider;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.streaming.api.operators.CoordinatedOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;

@Internal
public class SchemaOperatorFactory
extends SimpleOperatorFactory<Event>
implements CoordinatedOperatorFactory<Event>,
OneInputStreamOperatorFactory<Event, Event> {
    private static final long serialVersionUID = 1L;
    private final MetadataApplier metadataApplier;
    private final List<Tuple2<String, TableId>> routingRules;

    public SchemaOperatorFactory(MetadataApplier metadataApplier, List<Tuple2<String, TableId>> routingRules, Duration rpcTimeOut) {
        super((StreamOperator)new SchemaOperator(routingRules, rpcTimeOut));
        this.metadataApplier = metadataApplier;
        this.routingRules = routingRules;
    }

    public OperatorCoordinator.Provider getCoordinatorProvider(String operatorName, OperatorID operatorID) {
        return new SchemaRegistryProvider(operatorID, operatorName, this.metadataApplier, this.routingRules);
    }
}

