/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.vitess.shaded.io.grpc;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.base.Objects;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.base.Preconditions;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.Attributes;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.ChannelLogger;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.EquivalentAddressGroup;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.ExperimentalApi;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.ProxyDetector;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.Status;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.SynchronizationContext;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
public abstract class NameResolver {
    public abstract String getServiceAuthority();

    public void start(final Listener listener) {
        if (listener instanceof Listener2) {
            this.start((Listener2)listener);
        } else {
            this.start(new Listener2(){

                @Override
                public void onError(Status error) {
                    listener.onError(error);
                }

                @Override
                public void onResult(ResolutionResult resolutionResult) {
                    listener.onAddresses(resolutionResult.getAddresses(), resolutionResult.getAttributes());
                }
            });
        }
    }

    public void start(Listener2 listener) {
        this.start((Listener)listener);
    }

    public abstract void shutdown();

    public void refresh() {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static final class ConfigOrError {
        private final Status status;
        private final Object config;

        public static ConfigOrError fromConfig(Object config) {
            return new ConfigOrError(config);
        }

        public static ConfigOrError fromError(Status status) {
            return new ConfigOrError(status);
        }

        private ConfigOrError(Object config) {
            this.config = Preconditions.checkNotNull(config, "config");
            this.status = null;
        }

        private ConfigOrError(Status status) {
            this.config = null;
            this.status = Preconditions.checkNotNull(status, "status");
            Preconditions.checkArgument(!status.isOk(), "cannot use OK status: %s", (Object)status);
        }

        @Nullable
        public Object getConfig() {
            return this.config;
        }

        @Nullable
        public Status getError() {
            return this.status;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigOrError that = (ConfigOrError)o;
            return Objects.equal(this.status, that.status) && Objects.equal(this.config, that.config);
        }

        public int hashCode() {
            return Objects.hashCode(this.status, this.config);
        }

        public String toString() {
            if (this.config != null) {
                return MoreObjects.toStringHelper(this).add("config", this.config).toString();
            }
            assert (this.status != null);
            return MoreObjects.toStringHelper(this).add("error", this.status).toString();
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static final class ResolutionResult {
        private final List<EquivalentAddressGroup> addresses;
        private final Attributes attributes;
        @Nullable
        private final ConfigOrError serviceConfig;

        ResolutionResult(List<EquivalentAddressGroup> addresses, Attributes attributes, ConfigOrError serviceConfig) {
            this.addresses = Collections.unmodifiableList(new ArrayList<EquivalentAddressGroup>(addresses));
            this.attributes = Preconditions.checkNotNull(attributes, "attributes");
            this.serviceConfig = serviceConfig;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return ResolutionResult.newBuilder().setAddresses(this.addresses).setAttributes(this.attributes).setServiceConfig(this.serviceConfig);
        }

        public List<EquivalentAddressGroup> getAddresses() {
            return this.addresses;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        @Nullable
        public ConfigOrError getServiceConfig() {
            return this.serviceConfig;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("addresses", this.addresses).add("attributes", this.attributes).add("serviceConfig", this.serviceConfig).toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResolutionResult)) {
                return false;
            }
            ResolutionResult that = (ResolutionResult)obj;
            return Objects.equal(this.addresses, that.addresses) && Objects.equal(this.attributes, that.attributes) && Objects.equal(this.serviceConfig, that.serviceConfig);
        }

        public int hashCode() {
            return Objects.hashCode(this.addresses, this.attributes, this.serviceConfig);
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
        public static final class Builder {
            private List<EquivalentAddressGroup> addresses = Collections.emptyList();
            private Attributes attributes = Attributes.EMPTY;
            @Nullable
            private ConfigOrError serviceConfig;

            Builder() {
            }

            public Builder setAddresses(List<EquivalentAddressGroup> addresses) {
                this.addresses = addresses;
                return this;
            }

            public Builder setAttributes(Attributes attributes) {
                this.attributes = attributes;
                return this;
            }

            public Builder setServiceConfig(@Nullable ConfigOrError serviceConfig) {
                this.serviceConfig = serviceConfig;
                return this;
            }

            public ResolutionResult build() {
                return new ResolutionResult(this.addresses, this.attributes, this.serviceConfig);
            }
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static abstract class ServiceConfigParser {
        public abstract ConfigOrError parseServiceConfig(Map<String, ?> var1);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static final class Args {
        private final int defaultPort;
        private final ProxyDetector proxyDetector;
        private final SynchronizationContext syncContext;
        private final ServiceConfigParser serviceConfigParser;
        @Nullable
        private final ScheduledExecutorService scheduledExecutorService;
        @Nullable
        private final ChannelLogger channelLogger;
        @Nullable
        private final Executor executor;

        private Args(Integer defaultPort, ProxyDetector proxyDetector, SynchronizationContext syncContext, ServiceConfigParser serviceConfigParser, @Nullable ScheduledExecutorService scheduledExecutorService, @Nullable ChannelLogger channelLogger, @Nullable Executor executor) {
            this.defaultPort = Preconditions.checkNotNull(defaultPort, "defaultPort not set");
            this.proxyDetector = Preconditions.checkNotNull(proxyDetector, "proxyDetector not set");
            this.syncContext = Preconditions.checkNotNull(syncContext, "syncContext not set");
            this.serviceConfigParser = Preconditions.checkNotNull(serviceConfigParser, "serviceConfigParser not set");
            this.scheduledExecutorService = scheduledExecutorService;
            this.channelLogger = channelLogger;
            this.executor = executor;
        }

        public int getDefaultPort() {
            return this.defaultPort;
        }

        public ProxyDetector getProxyDetector() {
            return this.proxyDetector;
        }

        public SynchronizationContext getSynchronizationContext() {
            return this.syncContext;
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6454")
        public ScheduledExecutorService getScheduledExecutorService() {
            if (this.scheduledExecutorService == null) {
                throw new IllegalStateException("ScheduledExecutorService not set in Builder");
            }
            return this.scheduledExecutorService;
        }

        public ServiceConfigParser getServiceConfigParser() {
            return this.serviceConfigParser;
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6438")
        public ChannelLogger getChannelLogger() {
            if (this.channelLogger == null) {
                throw new IllegalStateException("ChannelLogger is not set in Builder");
            }
            return this.channelLogger;
        }

        @Nullable
        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6279")
        public Executor getOffloadExecutor() {
            return this.executor;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("defaultPort", this.defaultPort).add("proxyDetector", this.proxyDetector).add("syncContext", this.syncContext).add("serviceConfigParser", this.serviceConfigParser).add("scheduledExecutorService", this.scheduledExecutorService).add("channelLogger", this.channelLogger).add("executor", this.executor).toString();
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.setDefaultPort(this.defaultPort);
            builder.setProxyDetector(this.proxyDetector);
            builder.setSynchronizationContext(this.syncContext);
            builder.setServiceConfigParser(this.serviceConfigParser);
            builder.setScheduledExecutorService(this.scheduledExecutorService);
            builder.setChannelLogger(this.channelLogger);
            builder.setOffloadExecutor(this.executor);
            return builder;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private Integer defaultPort;
            private ProxyDetector proxyDetector;
            private SynchronizationContext syncContext;
            private ServiceConfigParser serviceConfigParser;
            private ScheduledExecutorService scheduledExecutorService;
            private ChannelLogger channelLogger;
            private Executor executor;

            Builder() {
            }

            public Builder setDefaultPort(int defaultPort) {
                this.defaultPort = defaultPort;
                return this;
            }

            public Builder setProxyDetector(ProxyDetector proxyDetector) {
                this.proxyDetector = Preconditions.checkNotNull(proxyDetector);
                return this;
            }

            public Builder setSynchronizationContext(SynchronizationContext syncContext) {
                this.syncContext = Preconditions.checkNotNull(syncContext);
                return this;
            }

            @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6454")
            public Builder setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
                this.scheduledExecutorService = Preconditions.checkNotNull(scheduledExecutorService);
                return this;
            }

            public Builder setServiceConfigParser(ServiceConfigParser parser) {
                this.serviceConfigParser = Preconditions.checkNotNull(parser);
                return this;
            }

            @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6438")
            public Builder setChannelLogger(ChannelLogger channelLogger) {
                this.channelLogger = Preconditions.checkNotNull(channelLogger);
                return this;
            }

            @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6279")
            public Builder setOffloadExecutor(Executor executor) {
                this.executor = executor;
                return this;
            }

            public Args build() {
                return new Args(this.defaultPort, this.proxyDetector, this.syncContext, this.serviceConfigParser, this.scheduledExecutorService, this.channelLogger, this.executor);
            }
        }
    }

    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static abstract class Helper {
        public abstract int getDefaultPort();

        public abstract ProxyDetector getProxyDetector();

        public SynchronizationContext getSynchronizationContext() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public ConfigOrError parseServiceConfig(Map<String, ?> rawServiceConfig) {
            throw new UnsupportedOperationException("should have been implemented");
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4972")
    public static @interface ResolutionResultAttr {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static abstract class Listener2
    implements Listener {
        @Override
        @Deprecated
        public final void onAddresses(List<EquivalentAddressGroup> servers, Attributes attributes) {
            this.onResult(ResolutionResult.newBuilder().setAddresses(servers).setAttributes(attributes).build());
        }

        public abstract void onResult(ResolutionResult var1);

        @Override
        public abstract void onError(Status var1);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    @ThreadSafe
    public static interface Listener {
        public void onAddresses(List<EquivalentAddressGroup> var1, Attributes var2);

        public void onError(Status var1);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    public static abstract class Factory {
        @Deprecated
        public static final Attributes.Key<Integer> PARAMS_DEFAULT_PORT = Attributes.Key.create("params-default-port");
        @Deprecated
        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/5113")
        public static final Attributes.Key<ProxyDetector> PARAMS_PROXY_DETECTOR = Attributes.Key.create("params-proxy-detector");
        @Deprecated
        private static final Attributes.Key<SynchronizationContext> PARAMS_SYNC_CONTEXT = Attributes.Key.create("params-sync-context");
        @Deprecated
        private static final Attributes.Key<ServiceConfigParser> PARAMS_PARSER = Attributes.Key.create("params-parser");

        @Nullable
        @Deprecated
        public NameResolver newNameResolver(URI targetUri, Attributes params) {
            Args args = Args.newBuilder().setDefaultPort(params.get(PARAMS_DEFAULT_PORT)).setProxyDetector(params.get(PARAMS_PROXY_DETECTOR)).setSynchronizationContext(params.get(PARAMS_SYNC_CONTEXT)).setServiceConfigParser(params.get(PARAMS_PARSER)).build();
            return this.newNameResolver(targetUri, args);
        }

        @Deprecated
        @Nullable
        public NameResolver newNameResolver(URI targetUri, final Helper helper) {
            return this.newNameResolver(targetUri, Attributes.newBuilder().set(PARAMS_DEFAULT_PORT, helper.getDefaultPort()).set(PARAMS_PROXY_DETECTOR, helper.getProxyDetector()).set(PARAMS_SYNC_CONTEXT, helper.getSynchronizationContext()).set(PARAMS_PARSER, new ServiceConfigParser(){

                @Override
                public ConfigOrError parseServiceConfig(Map<String, ?> rawServiceConfig) {
                    return helper.parseServiceConfig(rawServiceConfig);
                }
            }).build());
        }

        public NameResolver newNameResolver(URI targetUri, final Args args) {
            return this.newNameResolver(targetUri, new Helper(){

                @Override
                public int getDefaultPort() {
                    return args.getDefaultPort();
                }

                @Override
                public ProxyDetector getProxyDetector() {
                    return args.getProxyDetector();
                }

                @Override
                public SynchronizationContext getSynchronizationContext() {
                    return args.getSynchronizationContext();
                }

                @Override
                public ConfigOrError parseServiceConfig(Map<String, ?> rawServiceConfig) {
                    return args.getServiceConfigParser().parseServiceConfig(rawServiceConfig);
                }
            });
        }

        public abstract String getDefaultScheme();
    }
}

