/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.raw;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.tikv.common.util.Pair;
import org.tikv.common.util.ScanOption;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.shade.com.google.protobuf.ByteString;

public interface RawKVClientBase
extends AutoCloseable {
    public static final int MAX_RAW_SCAN_LIMIT = 10240;
    public static final int MAX_RAW_BATCH_LIMIT = 1024;
    public static final int RAW_BATCH_PUT_SIZE = 0x100000;
    public static final int RAW_BATCH_GET_SIZE = 16384;
    public static final int RAW_BATCH_DELETE_SIZE = 16384;

    public void put(ByteString var1, ByteString var2);

    public void put(ByteString var1, ByteString var2, long var3);

    public Optional<ByteString> putIfAbsent(ByteString var1, ByteString var2);

    public Optional<ByteString> putIfAbsent(ByteString var1, ByteString var2, long var3);

    public void compareAndSet(ByteString var1, Optional<ByteString> var2, ByteString var3);

    public void compareAndSet(ByteString var1, Optional<ByteString> var2, ByteString var3, long var4);

    public void batchPut(Map<ByteString, ByteString> var1);

    public void batchPut(Map<ByteString, ByteString> var1, long var2);

    public Optional<ByteString> get(ByteString var1);

    public List<Kvrpcpb.KvPair> batchGet(List<ByteString> var1);

    public void batchDelete(List<ByteString> var1);

    public Optional<Long> getKeyTTL(ByteString var1);

    public List<List<ByteString>> batchScanKeys(List<Pair<ByteString, ByteString>> var1, int var2);

    public List<List<Kvrpcpb.KvPair>> batchScan(List<ScanOption> var1);

    public List<Kvrpcpb.KvPair> scan(ByteString var1, ByteString var2, int var3);

    public List<Kvrpcpb.KvPair> scan(ByteString var1, ByteString var2, int var3, boolean var4);

    public List<Kvrpcpb.KvPair> scan(ByteString var1, int var2);

    public List<Kvrpcpb.KvPair> scan(ByteString var1, int var2, boolean var3);

    public List<Kvrpcpb.KvPair> scan(ByteString var1, ByteString var2);

    public List<Kvrpcpb.KvPair> scan(ByteString var1, ByteString var2, boolean var3);

    public List<Kvrpcpb.KvPair> scanPrefix(ByteString var1, int var2, boolean var3);

    public List<Kvrpcpb.KvPair> scanPrefix(ByteString var1);

    public List<Kvrpcpb.KvPair> scanPrefix(ByteString var1, boolean var2);

    public void delete(ByteString var1);

    public void deleteRange(ByteString var1, ByteString var2);

    public void deletePrefix(ByteString var1);
}

