/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.row;

import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.row.ObjectRowImpl;
import org.tikv.common.row.Row;
import org.tikv.common.row.RowReader;
import org.tikv.common.types.DataType;

public class DefaultRowReader
implements RowReader {
    private final CodecDataInput cdi;

    DefaultRowReader(CodecDataInput cdi) {
        this.cdi = cdi;
    }

    public static DefaultRowReader create(CodecDataInput cdi) {
        return new DefaultRowReader(cdi);
    }

    @Override
    public Row readRow(DataType[] dataTypes) {
        int length = dataTypes.length;
        Row row = ObjectRowImpl.create(length);
        for (int i = 0; i < length; ++i) {
            DataType type = dataTypes[i];
            if (type.isNextNull(this.cdi)) {
                this.cdi.readUnsignedByte();
                row.setNull(i);
                continue;
            }
            row.set(i, type, type.decode(this.cdi));
        }
        return row;
    }
}

