/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.region;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.key.Key;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.shade.com.google.common.collect.RangeMap;
import org.tikv.shade.com.google.common.collect.TreeRangeMap;
import org.tikv.shade.com.google.protobuf.ByteString;

public class RegionCache {
    private static final Logger logger = LoggerFactory.getLogger(RegionCache.class);
    private final Map<Long, TiRegion> regionCache = new HashMap<Long, TiRegion>();
    private final Map<Long, TiStore> storeCache = new HashMap<Long, TiStore>();
    private final RangeMap<Key, Long> keyToRegionIdCache = TreeRangeMap.create();

    public synchronized void invalidateAll() {
        this.regionCache.clear();
        this.storeCache.clear();
        this.keyToRegionIdCache.clear();
    }

    public synchronized TiRegion getRegionByKey(ByteString key, BackOffer backOffer) {
        Long regionId = key.isEmpty() ? this.keyToRegionIdCache.get(Key.toRawKey(key, true)) : this.keyToRegionIdCache.get(Key.toRawKey(key));
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("getRegionByKey key[%s] -> ID[%s]", KeyUtils.formatBytesUTF8(key), regionId));
        }
        if (regionId == null) {
            return null;
        }
        TiRegion region = this.regionCache.get(regionId);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("getRegionByKey ID[%s] -> Region[%s]", regionId, region));
        }
        return region;
    }

    public synchronized TiRegion putRegion(TiRegion region) {
        TiRegion oldRegion;
        if (logger.isDebugEnabled()) {
            logger.debug("putRegion: " + region);
        }
        if ((oldRegion = this.regionCache.get(region.getId())) != null) {
            if (oldRegion.getMeta().equals(region.getMeta())) {
                return oldRegion;
            }
            this.invalidateRegion(oldRegion);
        }
        this.regionCache.put(region.getId(), region);
        this.keyToRegionIdCache.put(KeyRangeUtils.makeRange(region.getStartKey(), region.getEndKey()), region.getId());
        return region;
    }

    @Deprecated
    public synchronized TiRegion getRegionById(long regionId) {
        TiRegion region = this.regionCache.get(regionId);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("getRegionByKey ID[%s] -> Region[%s]", regionId, region));
        }
        return region;
    }

    private synchronized TiRegion getRegionFromCache(long regionId) {
        return this.regionCache.get(regionId);
    }

    public synchronized void invalidateRegion(TiRegion region) {
        try {
            TiRegion oldRegion;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("invalidateRegion ID[%s]", region.getId()));
            }
            if ((oldRegion = this.regionCache.get(region.getId())) != null && oldRegion == region) {
                this.keyToRegionIdCache.remove(KeyRangeUtils.makeRange(region.getStartKey(), region.getEndKey()));
                this.regionCache.remove(region.getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void insertRegionToCache(TiRegion region) {
        try {
            TiRegion oldRegion = this.regionCache.get(region.getId());
            if (oldRegion != null) {
                this.keyToRegionIdCache.remove(KeyRangeUtils.makeRange(oldRegion.getStartKey(), oldRegion.getEndKey()));
            }
            this.regionCache.put(region.getId(), region);
            this.keyToRegionIdCache.put(KeyRangeUtils.makeRange(region.getStartKey(), region.getEndKey()), region.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean updateRegion(TiRegion expected, TiRegion region) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("invalidateRegion ID[%s]", region.getId()));
            }
            TiRegion oldRegion = this.regionCache.get(region.getId());
            if (!expected.getMeta().equals(oldRegion.getMeta())) {
                return false;
            }
            if (oldRegion != null) {
                this.keyToRegionIdCache.remove(KeyRangeUtils.makeRange(oldRegion.getStartKey(), oldRegion.getEndKey()));
            }
            this.regionCache.put(region.getId(), region);
            this.keyToRegionIdCache.put(KeyRangeUtils.makeRange(region.getStartKey(), region.getEndKey()), region.getId());
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public synchronized boolean updateStore(TiStore oldStore, TiStore newStore) {
        if (!newStore.isValid()) {
            return false;
        }
        if (oldStore == null) {
            this.storeCache.put(newStore.getId(), newStore);
            return true;
        }
        TiStore originStore = this.storeCache.get(oldStore.getId());
        if (originStore.equals(oldStore)) {
            this.storeCache.put(newStore.getId(), newStore);
            oldStore.markInvalid();
            return true;
        }
        return false;
    }

    public synchronized void invalidateAllRegionForStore(TiStore store) {
        TiStore oldStore = this.storeCache.get(store.getId());
        if (oldStore != store) {
            return;
        }
        ArrayList<TiRegion> regionToRemove = new ArrayList<TiRegion>();
        for (TiRegion r : this.regionCache.values()) {
            if (r.getLeader().getStoreId() != store.getId()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("invalidateAllRegionForStore Region[%s]", r));
            }
            regionToRemove.add(r);
        }
        logger.warn(String.format("invalid store [%d]", store.getId()));
        for (TiRegion r : regionToRemove) {
            this.keyToRegionIdCache.remove(KeyRangeUtils.makeRange(r.getStartKey(), r.getEndKey()));
            this.regionCache.remove(r.getId());
        }
    }

    public synchronized void invalidateStore(long storeId) {
        TiStore store = this.storeCache.remove(storeId);
        if (store != null) {
            store.markInvalid();
        }
    }

    public synchronized TiStore getStoreById(long id) {
        return this.storeCache.get(id);
    }

    public synchronized boolean putStore(long id, TiStore store) {
        TiStore oldStore = this.storeCache.get(id);
        if (oldStore != null) {
            if (oldStore.equals(store)) {
                return false;
            }
            oldStore.markInvalid();
        }
        this.storeCache.put(id, store);
        return true;
    }

    public synchronized void clearAll() {
        this.keyToRegionIdCache.clear();
        this.regionCache.clear();
    }
}

