/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.tikv.common.TiSession;
import org.tikv.common.key.IndexKey;
import org.tikv.common.key.Key;
import org.tikv.common.key.RowKey;
import org.tikv.common.meta.TiIndexInfo;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.region.TiRegion;

public class TiBatchWriteUtils {
    private static final Comparator<TiIndexInfo> tiIndexInfoComparator = Comparator.comparing(TiIndexInfo::getId);

    public static List<TiRegion> getRegionByIndex(TiSession session, TiTableInfo table, TiIndexInfo index) {
        ArrayList<TiRegion> regionList = new ArrayList<TiRegion>();
        Key min = IndexKey.toIndexKey(table.getId(), index.getId(), new Key[0]);
        Key max = min.nextPrefix();
        while (min.compareTo(max) < 0) {
            TiRegion region = session.getRegionManager().getRegionByKey(min.toByteString());
            regionList.add(region);
            min = Key.toRawKey(region.getEndKey());
        }
        return regionList;
    }

    public static List<TiRegion> getIndexRegions(TiSession session, TiTableInfo table) {
        return table.getIndices().stream().sorted(tiIndexInfoComparator).flatMap(index -> TiBatchWriteUtils.getRegionByIndex(session, table, index).stream()).collect(Collectors.toList());
    }

    public static List<TiRegion> getRecordRegions(TiSession session, TiTableInfo table) {
        ArrayList<TiRegion> regionList = new ArrayList<TiRegion>();
        Key key = RowKey.createMin(table.getId());
        RowKey endRowKey = RowKey.createBeyondMax(table.getId());
        while (key.compareTo(endRowKey) < 0) {
            TiRegion region = session.getRegionManager().getRegionByKey(key.toByteString());
            regionList.add(region);
            key = Key.toRawKey(region.getEndKey());
        }
        return regionList;
    }

    public static List<TiRegion> getRegionsByTable(TiSession session, TiTableInfo table) {
        List<TiRegion> recordRegions = TiBatchWriteUtils.getIndexRegions(session, table);
        recordRegions.addAll(TiBatchWriteUtils.getRecordRegions(session, table));
        return recordRegions;
    }
}

