/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.tidb.table;

import java.io.Serializable;
import org.apache.flink.cdc.connectors.tidb.table.TiKVMetadataConverter;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.util.Collector;

public class TiKVAppendMetadataCollector
implements Collector<RowData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final TiKVMetadataConverter[] metadataConverters;
    public transient TiKVMetadataConverter.TiKVRowValue row;
    public transient Collector<RowData> outputCollector;

    public TiKVAppendMetadataCollector(TiKVMetadataConverter[] metadataConverters) {
        this.metadataConverters = metadataConverters;
    }

    public void collect(RowData physicalRow) {
        GenericRowData metaRow = new GenericRowData(this.metadataConverters.length);
        for (int i = 0; i < this.metadataConverters.length; ++i) {
            Object meta = this.metadataConverters[i].read(this.row);
            metaRow.setField(i, meta);
        }
        JoinedRowData outRow = new JoinedRowData(physicalRow.getRowKind(), physicalRow, (RowData)metaRow);
        this.outputCollector.collect((Object)outRow);
    }

    public void close() {
    }
}

