/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression.visitor;

import java.util.HashMap;
import java.util.Map;
import org.tikv.common.expression.ColumnRef;
import org.tikv.common.expression.ComparisonBinaryExpression;
import org.tikv.common.expression.StringRegExpression;
import org.tikv.common.expression.visitor.RangeSetBuilder;
import org.tikv.common.key.TypedKey;
import org.tikv.common.meta.TiIndexColumn;
import org.tikv.common.meta.TiIndexInfo;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.types.DataType;
import org.tikv.shade.com.google.common.collect.Range;
import org.tikv.shade.com.google.common.collect.RangeSet;
import org.tikv.shade.com.google.common.collect.TreeRangeSet;

public class IndexRangeSetBuilder
extends RangeSetBuilder<TypedKey> {
    private final Map<ColumnRef, Integer> lengths;

    public IndexRangeSetBuilder(TiTableInfo table, TiIndexInfo index) {
        HashMap<ColumnRef, Integer> result = new HashMap<ColumnRef, Integer>();
        if (table != null && index != null) {
            for (TiIndexColumn indexColumn : index.getIndexColumns()) {
                ColumnRef columnRef = ColumnRef.create(indexColumn.getName(), table);
                result.put(columnRef, (int)indexColumn.getLength());
            }
        }
        this.lengths = result;
    }

    @Override
    protected RangeSet<TypedKey> visit(ComparisonBinaryExpression node, Void context) {
        ComparisonBinaryExpression.NormalizedPredicate predicate = node.normalize();
        if (predicate == null) {
            IndexRangeSetBuilder.throwOnError(node);
        }
        int prefixLen = this.lengths.getOrDefault(predicate.getColumnRef(), -1);
        TypedKey literal = predicate.getTypedLiteral(prefixLen);
        boolean loose = !DataType.isLengthUnSpecified(prefixLen);
        return this.visitComparisonBinaryExpr(node, context, literal, loose);
    }

    @Override
    protected RangeSet<TypedKey> visit(StringRegExpression node, Void context) {
        ColumnRef columnRef = node.getColumnRef();
        int prefixLen = this.lengths.getOrDefault(columnRef, -1);
        TypedKey literal = node.getTypedLiteral(prefixLen);
        TreeRangeSet<TypedKey> ranges = TreeRangeSet.create();
        switch (node.getRegType()) {
            case STARTS_WITH: {
                ranges.add(Range.atLeast(literal).intersection(Range.lessThan(literal.next())));
                break;
            }
            default: {
                IndexRangeSetBuilder.throwOnError(node);
            }
        }
        return ranges;
    }
}

