/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.columnar;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.joda.time.LocalDate;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.MyDecimal;
import org.tikv.common.columnar.TiColumnVector;
import org.tikv.common.columnar.TiCoreTime;
import org.tikv.common.exception.UnsupportedSyntaxException;
import org.tikv.common.types.AbstractDateTimeType;
import org.tikv.common.types.BitType;
import org.tikv.common.types.DataType;
import org.tikv.common.types.DateTimeType;
import org.tikv.common.types.DateType;
import org.tikv.common.types.EnumType;
import org.tikv.common.types.IntegerType;
import org.tikv.common.types.JsonType;
import org.tikv.common.types.TimeType;
import org.tikv.common.types.TimestampType;
import org.tikv.common.util.JsonUtils;
import org.tikv.shade.com.google.common.primitives.UnsignedLong;

public class TiChunkColumnVector
extends TiColumnVector {
    private final int fixLength;
    private final int numOfNulls;
    private final byte[] nullBitMaps;
    private final long[] offsets;
    private final ByteBuffer data;

    public TiChunkColumnVector(DataType dataType, int fixLength, int numOfRows, int numOfNulls, byte[] nullBitMaps, long[] offsets, ByteBuffer data) {
        super(dataType, numOfRows);
        this.fixLength = fixLength;
        this.numOfNulls = numOfNulls;
        this.nullBitMaps = nullBitMaps;
        this.data = data;
        this.offsets = offsets;
    }

    public final String typeName() {
        return this.dataType().getType().name();
    }

    public void free() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNull() {
        return this.numOfNulls > 0;
    }

    @Override
    public int numNulls() {
        return this.numOfNulls;
    }

    @Override
    public boolean isNullAt(int rowId) {
        int nullByte = this.nullBitMaps[rowId / 8] & 0xFF;
        return (nullByte & 1 << (rowId & 7)) == 0;
    }

    @Override
    public boolean getBoolean(int rowId) {
        return false;
    }

    @Override
    public byte getByte(int rowId) {
        return this.data.get();
    }

    @Override
    public short getShort(int rowId) {
        return this.data.getShort();
    }

    @Override
    public int getInt(int rowId) {
        return (int)this.getLong(rowId);
    }

    private boolean isDataTimeOrTimestamp() {
        return this.type instanceof DateTimeType || this.type instanceof TimestampType;
    }

    private long getTime(int rowId) {
        int startPos = rowId * this.fixLength;
        TiCoreTime coreTime = new TiCoreTime(this.data.getLong(startPos));
        int year = coreTime.getYear();
        int month = coreTime.getMonth();
        int day = coreTime.getDay();
        int hour = coreTime.getHour();
        int minute = coreTime.getMinute();
        int second = coreTime.getSecond();
        long microsecond = coreTime.getMicroSecond();
        boolean zeroDate = false;
        boolean zeroTime = false;
        boolean zeroInDate = false;
        if (year == 0 && month == 0 && day == 0) {
            zeroDate = true;
        }
        if (hour == 0 && minute == 0 && microsecond == 0L) {
            zeroTime = true;
        }
        if (month == 0 || day == 0) {
            zeroInDate = true;
        }
        if (zeroDate && zeroTime) {
            year = 1;
            month = 1;
            day = 1;
        } else if (!zeroDate && zeroInDate) {
            String dateString = String.format("%04d-%02d-%02d", year, month, day);
            try {
                Date d = new SimpleDateFormat("yyyy-MM-dd").parse(dateString);
                year = d.getYear() + 1900;
                month = d.getMonth() + 1;
                day = d.getDate();
            }
            catch (Exception e) {
                throw new UnsupportedSyntaxException("illegal date value: " + dateString);
            }
        }
        if (this.type instanceof DateType) {
            LocalDate date = new LocalDate(year, month, day);
            return ((DateType)this.type).getDays(date);
        }
        if (this.type instanceof DateTimeType || this.type instanceof TimestampType) {
            Timestamp ts = new Timestamp(year - 1900, month - 1, day, hour, minute, second, (int)microsecond * 1000);
            return ts.getTime() / 1000L * 1000000L + (long)(ts.getNanos() / 1000);
        }
        throw new UnsupportedOperationException("data, datetime, timestamp are already handled.");
    }

    private long getLongFromBinary(int rowId) {
        byte[] bytes = this.getBinary(rowId);
        if (bytes.length == 0) {
            return 0L;
        }
        long result = 0L;
        for (byte b : bytes) {
            result = result << 8 | (long)b;
        }
        return result;
    }

    @Override
    public long getLong(int rowId) {
        if (this.type instanceof IntegerType) {
            if (this.type instanceof BitType) {
                return this.getLongFromBinary(rowId);
            }
            return this.data.getLong(rowId * this.fixLength);
        }
        if (this.type instanceof AbstractDateTimeType) {
            return this.getTime(rowId);
        }
        if (this.type instanceof TimeType) {
            return this.data.getLong(rowId * this.fixLength);
        }
        throw new UnsupportedOperationException("only IntegerType and Time related are supported.");
    }

    @Override
    public float getFloat(int rowId) {
        return this.data.getFloat(rowId * this.fixLength);
    }

    @Override
    public double getDouble(int rowId) {
        return this.data.getDouble(rowId * this.fixLength);
    }

    private MyDecimal getMyDecimal(int rowId) {
        int startPos = rowId * this.fixLength;
        byte digitsInt = this.data.get(startPos);
        byte digitsFrac = this.data.get(startPos + 1);
        byte resultFrac = this.data.get(startPos + 2);
        boolean negative = this.data.get(startPos + 3) == 1;
        int[] wordBuf = new int[9];
        for (int i = 0; i < 9; ++i) {
            wordBuf[i] = this.data.getInt(startPos + 4 + i * 4);
        }
        return new MyDecimal(digitsInt, digitsFrac, negative, wordBuf);
    }

    @Override
    public BigDecimal getDecimal(int rowId, int precision, int scale) {
        if (this.type instanceof IntegerType) {
            return new BigDecimal(UnsignedLong.fromLongBits(this.getLong(rowId)).bigIntegerValue());
        }
        MyDecimal decimal = this.getMyDecimal(rowId);
        return decimal.toBigDecimal();
    }

    private String getEnumString(int rowId) {
        int start = (int)this.offsets[rowId];
        long end = this.offsets[rowId + 1];
        return new String(this.getRawBinary(start + 8, end));
    }

    private String getJsonString(int rowId) {
        long start = this.offsets[rowId];
        long end = this.offsets[rowId + 1];
        return JsonUtils.parseJson(new CodecDataInput(this.getRawBinary(start, end))).toString();
    }

    @Override
    public String getUTF8String(int rowId) {
        if (this.type instanceof EnumType) {
            return this.getEnumString(rowId);
        }
        if (this.type instanceof JsonType) {
            return this.getJsonString(rowId);
        }
        return new String(this.getBinary(rowId));
    }

    private byte[] getRawBinary(long start, long end) {
        byte[] buffer = new byte[(int)(end - start)];
        int i = 0;
        while ((long)i < end - start) {
            buffer[i] = this.data.get((int)(start + (long)i));
            ++i;
        }
        return buffer;
    }

    @Override
    public byte[] getBinary(int rowId) {
        int start = (int)this.offsets[rowId];
        long end = this.offsets[rowId + 1];
        return this.getRawBinary(start, end);
    }

    @Override
    protected TiColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("TiChunkColumnVector does not support this operation");
    }
}

