/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.TiKVException;
import org.tikv.common.operation.ErrorHandler;
import org.tikv.common.region.RegionErrorReceiver;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.TiRegion;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.kvproto.Errorpb;
import org.tikv.kvproto.Metapb;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.shade.io.grpc.Status;
import org.tikv.shade.io.grpc.StatusRuntimeException;

public class RegionErrorHandler<RespT>
implements ErrorHandler<RespT> {
    private static final Logger logger = LoggerFactory.getLogger(RegionErrorHandler.class);
    public static final int NO_LEADER_STORE_ID = 0;
    private final Function<RespT, Errorpb.Error> getRegionError;
    private final RegionManager regionManager;
    private final RegionErrorReceiver recv;

    public RegionErrorHandler(RegionManager regionManager, RegionErrorReceiver recv, Function<RespT, Errorpb.Error> getRegionError) {
        this.recv = recv;
        this.regionManager = regionManager;
        this.getRegionError = getRegionError;
    }

    @Override
    public boolean handleResponseError(BackOffer backOffer, RespT resp) {
        if (resp == null) {
            String msg = String.format("Request Failed with unknown reason for [%s]", this.recv.getRegion());
            return this.handleRequestError(backOffer, new GrpcException(msg));
        }
        Errorpb.Error error = this.getRegionError(resp);
        if (error != null) {
            return this.handleRegionError(backOffer, error);
        }
        return false;
    }

    public boolean handleRegionError(BackOffer backOffer, Errorpb.Error error) {
        if (error.hasNotLeader()) {
            BackOffFunction.BackOffFuncType backOffFuncType;
            boolean retry;
            long newStoreId = error.getNotLeader().getLeader().getStoreId();
            logger.warn(String.format("NotLeader Error with region id %d and store id %d, new store id %d", this.recv.getRegion().getId(), this.recv.getRegion().getLeader().getStoreId(), newStoreId));
            if (newStoreId != 0L) {
                TiRegion newRegion = this.regionManager.updateLeader(this.recv.getRegion(), newStoreId);
                retry = newRegion != null && this.recv.onNotLeader(newRegion, backOffer);
                backOffFuncType = BackOffFunction.BackOffFuncType.BoUpdateLeader;
            } else {
                logger.info(String.format("Received zero store id, from region %d try next time", this.recv.getRegion().getId()));
                backOffFuncType = BackOffFunction.BackOffFuncType.BoRegionMiss;
                retry = false;
            }
            if (!retry) {
                this.regionManager.invalidateRegion(this.recv.getRegion());
            }
            backOffer.doBackOff(backOffFuncType, new GrpcException(error.toString()));
            return retry;
        }
        if (error.hasStoreNotMatch()) {
            long storeId = this.recv.getRegion().getLeader().getStoreId();
            long actualStoreId = error.getStoreNotMatch().getActualStoreId();
            logger.warn(String.format("Store Not Match happened with region id %d, store id %d, actual store id %d", this.recv.getRegion().getId(), storeId, actualStoreId));
            this.regionManager.invalidateRegion(this.recv.getRegion());
            this.regionManager.invalidateStore(storeId);
            return false;
        }
        if (error.hasEpochNotMatch()) {
            logger.warn(String.format("tikv reports `EpochNotMatch` retry later, region: %s", this.recv.getRegion()));
            return this.onRegionEpochNotMatch(backOffer, error.getEpochNotMatch().getCurrentRegionsList());
        }
        if (error.hasServerIsBusy()) {
            logger.warn(String.format("Server is busy for region [%s], reason: %s", this.recv.getRegion(), error.getServerIsBusy().getReason()));
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoServerBusy, new StatusRuntimeException(Status.fromCode(Status.Code.UNAVAILABLE).withDescription(error.toString())));
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException(error.getMessage()));
            return true;
        }
        if (error.hasStaleCommand()) {
            logger.warn(String.format("Stale command for region [%s]", this.recv.getRegion()));
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException(error.getMessage()));
            return true;
        }
        if (error.hasRaftEntryTooLarge()) {
            logger.warn(String.format("Raft too large for region [%s]", this.recv.getRegion()));
            throw new StatusRuntimeException(Status.fromCode(Status.Code.UNAVAILABLE).withDescription(error.toString()));
        }
        if (error.hasKeyNotInRegion()) {
            ByteString invalidKey = error.getKeyNotInRegion().getKey();
            logger.error(String.format("Key not in region [%s] for key [%s], this error should not happen here.", this.recv.getRegion(), KeyUtils.formatBytesUTF8(invalidKey)));
            this.regionManager.clearRegionCache();
            throw new StatusRuntimeException(Status.UNKNOWN.withDescription(error.toString()));
        }
        logger.warn(String.format("Unknown error %s for region [%s]", error, this.recv.getRegion()));
        this.invalidateRegionStoreCache(this.recv.getRegion());
        if (error.getMessage().contains("Raft ProposalDropped")) {
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException(error.getMessage()));
            return true;
        }
        return false;
    }

    private boolean onRegionEpochNotMatch(BackOffer backOffer, List<Metapb.Region> currentRegions) {
        if (currentRegions.size() == 0) {
            this.regionManager.onRegionStale(this.recv.getRegion());
            return false;
        }
        for (Metapb.Region meta : currentRegions) {
            if (meta.getId() != this.recv.getRegion().getId() || meta.getRegionEpoch().getConfVer() >= this.recv.getRegion().getVerID().getConfVer() && meta.getRegionEpoch().getVersion() >= this.recv.getRegion().getVerID().getVer()) continue;
            String errorMsg = String.format("region epoch is ahead of tikv, region: %s, currentRegions: %s", this.recv.getRegion(), currentRegions);
            logger.info(errorMsg);
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiKVException(errorMsg));
            return true;
        }
        boolean needInvalidateOld = true;
        ArrayList<TiRegion> newRegions = new ArrayList<TiRegion>(currentRegions.size());
        for (Metapb.Region meta : currentRegions) {
            TiRegion region = this.regionManager.createRegion(meta, backOffer);
            newRegions.add(region);
            if (this.recv.getRegion().getVerID() != region.getVerID()) continue;
            needInvalidateOld = false;
        }
        if (needInvalidateOld) {
            this.regionManager.onRegionStale(this.recv.getRegion());
        }
        for (TiRegion region : newRegions) {
            this.regionManager.insertRegionToCache(region);
        }
        return false;
    }

    @Override
    public boolean handleRequestError(BackOffer backOffer, Exception e) {
        if (this.recv.onStoreUnreachable(backOffer)) {
            if (!backOffer.canRetryAfterSleep(BackOffFunction.BackOffFuncType.BoTiKVRPC)) {
                this.regionManager.onRequestFail(this.recv.getRegion());
                throw new GrpcException("retry is exhausted.", e);
            }
            return true;
        }
        logger.warn("request failed because of: " + e.getMessage());
        if (!backOffer.canRetryAfterSleep(BackOffFunction.BackOffFuncType.BoTiKVRPC)) {
            this.regionManager.onRequestFail(this.recv.getRegion());
            throw new GrpcException("send tikv request error: " + e.getMessage() + ", try next peer later", e);
        }
        return false;
    }

    public Errorpb.Error getRegionError(RespT resp) {
        if (this.getRegionError != null) {
            return this.getRegionError.apply(resp);
        }
        return null;
    }

    public TiRegion getRegion() {
        return this.recv.getRegion();
    }

    private void invalidateRegionStoreCache(TiRegion ctxRegion) {
        this.regionManager.invalidateRegion(ctxRegion);
        this.regionManager.invalidateStore(ctxRegion.getLeader().getStoreId());
    }
}

