/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.key;

import java.io.Serializable;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.exception.TiExpressionException;
import org.tikv.common.key.Key;
import org.tikv.common.key.TypedKey;

public class RowKey
extends Key
implements Serializable {
    private static final byte[] REC_PREFIX_SEP = new byte[]{95, 114};
    private final long tableId;
    private final long handle;
    private final boolean maxHandleFlag;

    private RowKey(long tableId, long handle) {
        super(RowKey.encode(tableId, handle));
        this.tableId = tableId;
        this.handle = handle;
        this.maxHandleFlag = false;
    }

    private RowKey(long tableId) {
        super(RowKey.encodeBeyondMaxHandle(tableId));
        this.tableId = tableId;
        this.handle = Long.MAX_VALUE;
        this.maxHandleFlag = true;
    }

    public static RowKey toRowKey(long tableId, long handle) {
        return new RowKey(tableId, handle);
    }

    public static RowKey toRowKey(long tableId, TypedKey handle) {
        Object obj = handle.getValue();
        if (obj instanceof Long) {
            return new RowKey(tableId, (Long)obj);
        }
        throw new TiExpressionException("Cannot encode row key with non-long type");
    }

    public static RowKey createMin(long tableId) {
        return RowKey.toRowKey(tableId, Long.MIN_VALUE);
    }

    public static RowKey createBeyondMax(long tableId) {
        return new RowKey(tableId);
    }

    public static RowKey decode(byte[] value) {
        CodecDataInput cdi = new CodecDataInput(value);
        cdi.readByte();
        long tableId = Codec.IntegerCodec.readLong(cdi);
        cdi.readByte();
        cdi.readByte();
        long handle = Codec.IntegerCodec.readLong(cdi);
        return RowKey.toRowKey(tableId, handle);
    }

    private static byte[] encode(long tableId, long handle) {
        CodecDataOutput cdo = new CodecDataOutput();
        RowKey.encodePrefix(cdo, tableId);
        Codec.IntegerCodec.writeLong(cdo, handle);
        return cdo.toBytes();
    }

    private static byte[] encodeBeyondMaxHandle(long tableId) {
        return RowKey.prefixNext(RowKey.encode(tableId, Long.MAX_VALUE));
    }

    private static void encodePrefix(CodecDataOutput cdo, long tableId) {
        cdo.write(TBL_PREFIX);
        Codec.IntegerCodec.writeLong(cdo, tableId);
        cdo.write(REC_PREFIX_SEP);
    }

    @Override
    public RowKey next() {
        long handle = this.getHandle();
        boolean maxHandleFlag = this.getMaxHandleFlag();
        if (maxHandleFlag) {
            throw new TiClientInternalException("Handle overflow for Long MAX");
        }
        if (handle == Long.MAX_VALUE) {
            return RowKey.createBeyondMax(this.tableId);
        }
        return new RowKey(this.tableId, handle + 1L);
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getHandle() {
        return this.handle;
    }

    private boolean getMaxHandleFlag() {
        return this.maxHandleFlag;
    }

    @Override
    public String toString() {
        return Long.toString(this.handle);
    }

    public static class DecodeResult {
        public long handle;
        public Status status;

        public static enum Status {
            MIN,
            MAX,
            EQUAL,
            LESS,
            GREATER,
            UNKNOWN_INF;

        }
    }
}

