/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.enumerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.connectors.base.config.SourceConfig;
import org.apache.flink.cdc.connectors.base.source.assigner.AssignerStatus;
import org.apache.flink.cdc.connectors.base.source.assigner.HybridSplitAssigner;
import org.apache.flink.cdc.connectors.base.source.assigner.SplitAssigner;
import org.apache.flink.cdc.connectors.base.source.assigner.state.PendingSplitsState;
import org.apache.flink.cdc.connectors.base.source.meta.events.FinishedSnapshotSplitsAckEvent;
import org.apache.flink.cdc.connectors.base.source.meta.events.FinishedSnapshotSplitsReportEvent;
import org.apache.flink.cdc.connectors.base.source.meta.events.FinishedSnapshotSplitsRequestEvent;
import org.apache.flink.cdc.connectors.base.source.meta.events.LatestFinishedSplitsNumberEvent;
import org.apache.flink.cdc.connectors.base.source.meta.events.LatestFinishedSplitsNumberRequestEvent;
import org.apache.flink.cdc.connectors.base.source.meta.events.StreamSplitAssignedEvent;
import org.apache.flink.cdc.connectors.base.source.meta.events.StreamSplitMetaEvent;
import org.apache.flink.cdc.connectors.base.source.meta.events.StreamSplitMetaRequestEvent;
import org.apache.flink.cdc.connectors.base.source.meta.events.StreamSplitUpdateAckEvent;
import org.apache.flink.cdc.connectors.base.source.meta.events.StreamSplitUpdateRequestEvent;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.meta.split.StreamSplit;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class IncrementalSourceEnumerator
implements SplitEnumerator<SourceSplitBase, PendingSplitsState> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalSourceEnumerator.class);
    private static final long CHECK_EVENT_INTERVAL = 30000L;
    protected final SplitEnumeratorContext<SourceSplitBase> context;
    private final SourceConfig sourceConfig;
    protected final SplitAssigner splitAssigner;
    protected final TreeSet<Integer> readersAwaitingSplit;
    private List<List<FinishedSnapshotSplitInfo>> finishedSnapshotSplitMeta;
    private Boundedness boundedness;
    @Nullable
    protected Integer streamSplitTaskId = null;
    private boolean isStreamSplitUpdateRequestAlreadySent = false;

    public IncrementalSourceEnumerator(SplitEnumeratorContext<SourceSplitBase> context, SourceConfig sourceConfig, SplitAssigner splitAssigner, Boundedness boundedness) {
        this.context = context;
        this.sourceConfig = sourceConfig;
        this.splitAssigner = splitAssigner;
        this.readersAwaitingSplit = new TreeSet();
        this.boundedness = boundedness;
    }

    public void start() {
        this.splitAssigner.open();
        this.requestStreamSplitUpdateIfNeed();
        this.context.callAsync(this::getRegisteredReader, this::syncWithReaders, 30000L, 30000L);
    }

    public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
        if (!this.context.registeredReaders().containsKey(subtaskId)) {
            return;
        }
        this.readersAwaitingSplit.add(subtaskId);
        this.assignSplits();
    }

    public void addSplitsBack(List<SourceSplitBase> splits, int subtaskId) {
        LOG.debug("Incremental Source Enumerator adds splits back: {}", splits);
        Optional<SourceSplitBase> streamSplit = splits.stream().filter(SourceSplitBase::isStreamSplit).findAny();
        if (streamSplit.isPresent()) {
            LOG.info("The enumerator adds add stream split back: {}", streamSplit);
            this.streamSplitTaskId = null;
        }
        this.splitAssigner.addSplits(splits);
    }

    public void addReader(int subtaskId) {
        this.requestStreamSplitUpdateIfNeed();
    }

    public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
        if (sourceEvent instanceof FinishedSnapshotSplitsReportEvent) {
            LOG.info("The enumerator receives finished split offsets {} from subtask {}.", (Object)sourceEvent, (Object)subtaskId);
            FinishedSnapshotSplitsReportEvent reportEvent = (FinishedSnapshotSplitsReportEvent)sourceEvent;
            Map<String, Offset> finishedOffsets = reportEvent.getFinishedOffsets();
            this.splitAssigner.onFinishedSplits(finishedOffsets);
            this.requestStreamSplitUpdateIfNeed();
            FinishedSnapshotSplitsAckEvent ackEvent = new FinishedSnapshotSplitsAckEvent(new ArrayList<String>(finishedOffsets.keySet()));
            this.context.sendEventToSourceReader(subtaskId, (SourceEvent)ackEvent);
        } else if (sourceEvent instanceof StreamSplitMetaRequestEvent) {
            LOG.debug("The enumerator receives request for stream split meta from subtask {}.", (Object)subtaskId);
            this.sendStreamMetaRequestEvent(subtaskId, (StreamSplitMetaRequestEvent)sourceEvent);
        } else if (sourceEvent instanceof LatestFinishedSplitsNumberRequestEvent) {
            LOG.info("The enumerator receives request from subtask {} for the latest finished splits number after added newly tables. ", (Object)subtaskId);
            this.handleLatestFinishedSplitNumberRequest(subtaskId);
        } else if (sourceEvent instanceof StreamSplitUpdateAckEvent) {
            LOG.info("The enumerator receives event that the streamSplit split has been updated from subtask {}. ", (Object)subtaskId);
            this.splitAssigner.onStreamSplitUpdated();
        } else if (sourceEvent instanceof StreamSplitAssignedEvent) {
            LOG.info("The enumerator receives notice from subtask {} for the stream split assignment. ", (Object)subtaskId);
            this.streamSplitTaskId = subtaskId;
        }
    }

    public PendingSplitsState snapshotState(long checkpointId) {
        return this.splitAssigner.snapshotState(checkpointId);
    }

    public void notifyCheckpointComplete(long checkpointId) {
        this.splitAssigner.notifyCheckpointComplete(checkpointId);
        this.assignSplits();
    }

    public void close() throws IOException {
        LOG.info("Closing enumerator...");
        this.splitAssigner.close();
    }

    protected void assignSplits() {
        Iterator<Integer> awaitingReader = this.readersAwaitingSplit.iterator();
        while (awaitingReader.hasNext()) {
            int nextAwaiting = awaitingReader.next();
            if (!this.context.registeredReaders().containsKey(nextAwaiting)) {
                awaitingReader.remove();
                continue;
            }
            if (this.shouldCloseIdleReader(nextAwaiting)) {
                this.context.signalNoMoreSplits(nextAwaiting);
                awaitingReader.remove();
                LOG.info("Close idle reader of subtask {}", (Object)nextAwaiting);
                continue;
            }
            Optional<SourceSplitBase> split = this.splitAssigner.getNext();
            if (split.isPresent()) {
                SourceSplitBase sourceSplit = split.get();
                this.context.assignSplit((SourceSplit)sourceSplit, nextAwaiting);
                if (sourceSplit instanceof StreamSplit) {
                    this.streamSplitTaskId = nextAwaiting;
                }
                awaitingReader.remove();
                LOG.info("Assign split {} to subtask {}", (Object)sourceSplit, (Object)nextAwaiting);
                continue;
            }
            this.requestStreamSplitUpdateIfNeed();
            break;
        }
    }

    private boolean shouldCloseIdleReader(int nextAwaiting) {
        return this.splitAssigner.noMoreSplits() && (this.boundedness == Boundedness.BOUNDED || this.sourceConfig.isCloseIdleReaders() && this.streamSplitTaskId != null && this.streamSplitTaskId != nextAwaiting);
    }

    protected int[] getRegisteredReader() {
        return this.context.registeredReaders().keySet().stream().mapToInt(Integer::intValue).toArray();
    }

    protected void syncWithReaders(int[] subtaskIds, Throwable t) {
        if (t != null) {
            throw new FlinkRuntimeException("Failed to list obtain registered readers due to:", t);
        }
        if (this.splitAssigner.waitingForFinishedSplits()) {
            for (int subtaskId : subtaskIds) {
                this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new FinishedSnapshotSplitsRequestEvent());
            }
        }
        this.requestStreamSplitUpdateIfNeed();
    }

    private void requestStreamSplitUpdateIfNeed() {
        if (!this.isStreamSplitUpdateRequestAlreadySent && AssignerStatus.isNewlyAddedAssigningSnapshotFinished(this.splitAssigner.getAssignerStatus())) {
            if (this.streamSplitTaskId != null) {
                this.isStreamSplitUpdateRequestAlreadySent = true;
                LOG.info("The enumerator requests subtask {} to update the stream split after newly added table.", (Object)this.streamSplitTaskId);
                this.context.sendEventToSourceReader(this.streamSplitTaskId.intValue(), (SourceEvent)new StreamSplitUpdateRequestEvent());
            } else {
                for (int reader : this.getRegisteredReader()) {
                    this.isStreamSplitUpdateRequestAlreadySent = true;
                    LOG.info("The enumerator requests subtask {} to update the stream split after newly added table.", (Object)reader);
                    this.context.sendEventToSourceReader(reader, (SourceEvent)new StreamSplitUpdateRequestEvent());
                }
            }
        }
    }

    private void sendStreamMetaRequestEvent(int subTask, StreamSplitMetaRequestEvent requestEvent) {
        int totalFinishedSplitSizeOfEnumerator;
        if (this.finishedSnapshotSplitMeta == null) {
            List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos = this.splitAssigner.getFinishedSplitInfos();
            if (finishedSnapshotSplitInfos.isEmpty()) {
                LOG.error("The assigner offer empty finished split information, this should not happen");
                throw new FlinkRuntimeException("The assigner offer empty finished split information, this should not happen");
            }
            this.finishedSnapshotSplitMeta = Lists.partition(finishedSnapshotSplitInfos, this.sourceConfig.getSplitMetaGroupSize());
        }
        int requestMetaGroupId = requestEvent.getRequestMetaGroupId();
        int totalFinishedSplitSizeOfReader = requestEvent.getTotalFinishedSplitSize();
        if (totalFinishedSplitSizeOfReader > (totalFinishedSplitSizeOfEnumerator = this.splitAssigner.getFinishedSplitInfos().size())) {
            LOG.warn("Total finished split size of subtask {} is {}, while total finished split size of enumerator is only {}. Try to truncate it", new Object[]{subTask, totalFinishedSplitSizeOfReader, totalFinishedSplitSizeOfEnumerator});
            StreamSplitMetaEvent metadataEvent = new StreamSplitMetaEvent(requestEvent.getSplitId(), requestMetaGroupId, null, totalFinishedSplitSizeOfEnumerator);
            this.context.sendEventToSourceReader(subTask, (SourceEvent)metadataEvent);
        } else if (this.finishedSnapshotSplitMeta.size() > requestMetaGroupId) {
            List<FinishedSnapshotSplitInfo> metaToSend = this.finishedSnapshotSplitMeta.get(requestMetaGroupId);
            StreamSplitMetaEvent metadataEvent = new StreamSplitMetaEvent(requestEvent.getSplitId(), requestMetaGroupId, metaToSend.stream().map(FinishedSnapshotSplitInfo::serialize).collect(Collectors.toList()), totalFinishedSplitSizeOfEnumerator);
            this.context.sendEventToSourceReader(subTask, (SourceEvent)metadataEvent);
        } else {
            throw new FlinkRuntimeException(String.format("The enumerator received invalid request meta group id %s, the valid meta group id range is [0, %s]. Total finished split size of reader is %s, while the total finished split size of enumerator is %s.", requestMetaGroupId, this.finishedSnapshotSplitMeta.size() - 1, totalFinishedSplitSizeOfReader, totalFinishedSplitSizeOfEnumerator));
        }
    }

    private void handleLatestFinishedSplitNumberRequest(int subtaskId) {
        if (this.splitAssigner instanceof HybridSplitAssigner) {
            this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new LatestFinishedSplitsNumberEvent(this.splitAssigner.getFinishedSplitInfos().size()));
        }
    }
}

