/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.cdc.common.types.DataTypeVisitor;

@PublicEvolving
public class CharType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final int EMPTY_LITERAL_LENGTH = 0;
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_LENGTH = 1;
    private static final String FORMAT = "CHAR(%d)";
    private final int length;

    public CharType(boolean isNullable, int length) {
        super(isNullable, DataTypeRoot.CHAR);
        if (length < 1) {
            throw new IllegalArgumentException(String.format("Character string length must be between %d and %d (both inclusive).", 1, Integer.MAX_VALUE));
        }
        this.length = length;
    }

    public CharType(int length) {
        this(true, length);
    }

    public CharType() {
        this(1);
    }

    private CharType(int length, boolean isNullable) {
        super(isNullable, DataTypeRoot.CHAR);
        this.length = length;
    }

    public static CharType ofEmptyLiteral() {
        return new CharType(0, false);
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new CharType(this.length, isNullable);
    }

    @Override
    public String asSerializableString() {
        if (this.length == 0) {
            throw new IllegalArgumentException("Zero-length character strings have no serializable string representation.");
        }
        return this.withNullability(FORMAT, this.length);
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.length);
    }

    @Override
    public List<DataType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CharType charType = (CharType)o;
        return this.length == charType.length;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.length);
    }
}

