/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.OperationType;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.function.HashFunction;
import org.apache.flink.cdc.common.function.HashFunctionProvider;
import org.apache.flink.cdc.common.schema.Schema;

public class DefaultDataChangeEventHashFunctionProvider
implements HashFunctionProvider<DataChangeEvent> {
    private static final long serialVersionUID = 1L;

    @Override
    public HashFunction<DataChangeEvent> getHashFunction(@Nullable TableId tableId, Schema schema) {
        return new DefaultDataChangeEventHashFunction(schema);
    }

    static class DefaultDataChangeEventHashFunction
    implements HashFunction<DataChangeEvent> {
        private final List<RecordData.FieldGetter> primaryKeyGetters;

        public DefaultDataChangeEventHashFunction(Schema schema) {
            this.primaryKeyGetters = this.createFieldGetters(schema);
        }

        @Override
        public int hashcode(DataChangeEvent event) {
            ArrayList<Object> objectsToHash = new ArrayList<Object>();
            TableId tableId = event.tableId();
            Optional.ofNullable(tableId.getNamespace()).ifPresent(objectsToHash::add);
            Optional.ofNullable(tableId.getSchemaName()).ifPresent(objectsToHash::add);
            objectsToHash.add(tableId.getTableName());
            RecordData data = event.op().equals((Object)OperationType.DELETE) ? event.before() : event.after();
            for (RecordData.FieldGetter primaryKeyGetter : this.primaryKeyGetters) {
                objectsToHash.add(primaryKeyGetter.getFieldOrNull(data));
            }
            return Objects.hash(objectsToHash.toArray()) * 31 & Integer.MAX_VALUE;
        }

        private List<RecordData.FieldGetter> createFieldGetters(Schema schema) {
            ArrayList<RecordData.FieldGetter> fieldGetters = new ArrayList<RecordData.FieldGetter>(schema.primaryKeys().size());
            schema.primaryKeys().stream().mapToInt(pk -> {
                int index = schema.getColumnNames().indexOf(pk);
                if (index == -1) {
                    throw new IllegalStateException(String.format("Unable to find column \"%s\" which is defined as primary key", pk));
                }
                return index;
            }).forEach(primaryKeyPosition -> fieldGetters.add(RecordData.createFieldGetter(schema.getColumns().get(primaryKeyPosition).getType(), primaryKeyPosition)));
            return fieldGetters;
        }
    }
}

