/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;

public class CooperativeStickyAssignor
extends AbstractStickyAssignor {
    public static final String COOPERATIVE_STICKY_ASSIGNOR_NAME = "cooperative-sticky";
    private static final String GENERATION_KEY_NAME = "generation";
    private static final Schema COOPERATIVE_STICKY_ASSIGNOR_USER_DATA_V0 = new Schema(new Field("generation", Type.INT32));
    private int generation = -1;

    @Override
    public String name() {
        return COOPERATIVE_STICKY_ASSIGNOR_NAME;
    }

    @Override
    public List<ConsumerPartitionAssignor.RebalanceProtocol> supportedProtocols() {
        return Arrays.asList(ConsumerPartitionAssignor.RebalanceProtocol.COOPERATIVE, ConsumerPartitionAssignor.RebalanceProtocol.EAGER);
    }

    @Override
    public void onAssignment(ConsumerPartitionAssignor.Assignment assignment, ConsumerGroupMetadata metadata) {
        this.generation = metadata.generationId();
    }

    @Override
    public ByteBuffer subscriptionUserData(Set<String> topics) {
        Struct struct = new Struct(COOPERATIVE_STICKY_ASSIGNOR_USER_DATA_V0);
        struct.set(GENERATION_KEY_NAME, (Object)this.generation);
        ByteBuffer buffer = ByteBuffer.allocate(COOPERATIVE_STICKY_ASSIGNOR_USER_DATA_V0.sizeOf(struct));
        COOPERATIVE_STICKY_ASSIGNOR_USER_DATA_V0.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    @Override
    protected AbstractStickyAssignor.MemberData memberData(ConsumerPartitionAssignor.Subscription subscription) {
        Optional<Integer> encodedGeneration;
        ByteBuffer buffer = subscription.userData();
        if (buffer == null) {
            encodedGeneration = Optional.empty();
        } else {
            try {
                Struct struct = COOPERATIVE_STICKY_ASSIGNOR_USER_DATA_V0.read(buffer);
                encodedGeneration = Optional.of(struct.getInt(GENERATION_KEY_NAME));
            }
            catch (Exception e) {
                encodedGeneration = Optional.of(-1);
            }
        }
        return new AbstractStickyAssignor.MemberData(subscription.ownedPartitions(), encodedGeneration);
    }

    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
        Map<String, List<TopicPartition>> assignments = super.assign(partitionsPerTopic, subscriptions);
        Map<TopicPartition, String> partitionsTransferringOwnership = this.partitionsTransferringOwnership == null ? this.computePartitionsTransferringOwnership(subscriptions, assignments) : this.partitionsTransferringOwnership;
        this.adjustAssignment(assignments, partitionsTransferringOwnership);
        return assignments;
    }

    private void adjustAssignment(Map<String, List<TopicPartition>> assignments, Map<TopicPartition, String> partitionsTransferringOwnership) {
        for (Map.Entry<TopicPartition, String> partitionEntry : partitionsTransferringOwnership.entrySet()) {
            assignments.get(partitionEntry.getValue()).remove(partitionEntry.getKey());
        }
    }

    private Map<TopicPartition, String> computePartitionsTransferringOwnership(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments) {
        HashMap<TopicPartition, String> allAddedPartitions = new HashMap<TopicPartition, String>();
        HashSet<TopicPartition> allRevokedPartitions = new HashSet<TopicPartition>();
        for (Map.Entry<String, List<TopicPartition>> entry : assignments.entrySet()) {
            String consumer = entry.getKey();
            List<TopicPartition> ownedPartitions = subscriptions.get(consumer).ownedPartitions();
            List<TopicPartition> assignedPartitions = entry.getValue();
            HashSet<TopicPartition> ownedPartitionsSet = new HashSet<TopicPartition>(ownedPartitions);
            for (TopicPartition tp : assignedPartitions) {
                if (ownedPartitionsSet.contains(tp)) continue;
                allAddedPartitions.put(tp, consumer);
            }
            HashSet<TopicPartition> assignedPartitionsSet = new HashSet<TopicPartition>(assignedPartitions);
            for (TopicPartition tp : ownedPartitions) {
                if (assignedPartitionsSet.contains(tp)) continue;
                allRevokedPartitions.add(tp);
            }
        }
        allAddedPartitions.keySet().retainAll(allRevokedPartitions);
        return allAddedPartitions;
    }
}

