/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source.utils;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.TableId;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.cdc.connectors.base.utils.SourceRecordUtils;
import org.apache.flink.table.types.logical.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresQueryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresQueryUtils.class);

    private PostgresQueryUtils() {
    }

    public static Object[] queryMinMax(JdbcConnection jdbc, TableId tableId, Column column) throws SQLException {
        String minMaxQuery = String.format("SELECT MIN(%s), MAX(%s) FROM %s", PostgresQueryUtils.quoteForMinMax(column), PostgresQueryUtils.quoteForMinMax(column), PostgresQueryUtils.quote(tableId));
        return jdbc.queryAndMap(minMaxQuery, rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", minMaxQuery));
            }
            return SourceRecordUtils.rowToArray(rs, 2);
        });
    }

    public static long queryApproximateRowCnt(JdbcConnection jdbc, TableId tableId) throws SQLException {
        String query = "SELECT reltuples::bigint FROM pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE n.nspname = ? AND c.relname = ?";
        return jdbc.prepareQueryAndMap("SELECT reltuples::bigint FROM pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE n.nspname = ? AND c.relname = ?", ps -> {
            ps.setString(1, tableId.schema());
            ps.setString(2, tableId.table());
        }, rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", "SELECT reltuples::bigint FROM pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE n.nspname = ? AND c.relname = ?"));
            }
            LOG.info("queryApproximateRowCnt: {} => {}", (Object)"SELECT reltuples::bigint FROM pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE n.nspname = ? AND c.relname = ?", (Object)rs.getLong(1));
            return rs.getLong(1);
        });
    }

    public static Object queryMin(JdbcConnection jdbc, TableId tableId, Column column, Object excludedLowerBound) throws SQLException {
        String query = String.format("SELECT MIN(%s) FROM %s WHERE %s > %s", PostgresQueryUtils.quoteForMinMax(column), PostgresQueryUtils.quote(tableId), PostgresQueryUtils.quote(column.name()), PostgresQueryUtils.castParam(column));
        return jdbc.prepareQueryAndMap(query, ps -> ps.setObject(1, excludedLowerBound), rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", query));
            }
            LOG.info("{} => {}", (Object)query, rs.getObject(1));
            return rs.getObject(1);
        });
    }

    public static Object queryNextChunkMax(JdbcConnection jdbc, TableId tableId, Column splitColumn, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = PostgresQueryUtils.quote(splitColumn.name());
        String query = String.format("SELECT MAX(%s) FROM (SELECT %s FROM %s WHERE %s >= %s ORDER BY %s ASC LIMIT %s) AS T", PostgresQueryUtils.quoteForMinMax(splitColumn), quotedColumn, PostgresQueryUtils.quote(tableId), quotedColumn, PostgresQueryUtils.castParam(splitColumn), quotedColumn, chunkSize);
        return jdbc.prepareQueryAndMap(query, ps -> ps.setObject(1, includedLowerBound), rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", query));
            }
            return rs.getObject(1);
        });
    }

    public static String buildSplitScanQuery(TableId tableId, RowType pkRowType, boolean isFirstSplit, boolean isLastSplit, List<String> uuidFields) {
        return PostgresQueryUtils.buildSplitQuery(tableId, pkRowType, isFirstSplit, isLastSplit, uuidFields, -1, true);
    }

    private static String buildSplitQuery(TableId tableId, RowType pkRowType, boolean isFirstSplit, boolean isLastSplit, List<String> uuidFields, int limitSize, boolean isScanningData) {
        StringBuilder sql;
        String condition;
        if (isFirstSplit && isLastSplit) {
            condition = null;
        } else if (isFirstSplit) {
            sql = new StringBuilder();
            PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " <= ", uuidFields);
            if (isScanningData) {
                sql.append(" AND NOT (");
                PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " = ", uuidFields);
                sql.append(")");
            }
            condition = sql.toString();
        } else if (isLastSplit) {
            sql = new StringBuilder();
            PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " >= ", uuidFields);
            condition = sql.toString();
        } else {
            sql = new StringBuilder();
            PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " >= ", uuidFields);
            if (isScanningData) {
                sql.append(" AND NOT (");
                PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " = ", uuidFields);
                sql.append(")");
            }
            sql.append(" AND ");
            PostgresQueryUtils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " <= ", uuidFields);
            condition = sql.toString();
        }
        if (isScanningData) {
            return PostgresQueryUtils.buildSelectWithRowLimits(tableId, limitSize, "*", Optional.ofNullable(condition), Optional.empty());
        }
        String orderBy = pkRowType.getFieldNames().stream().collect(Collectors.joining(", "));
        return PostgresQueryUtils.buildSelectWithBoundaryRowLimits(tableId, limitSize, PostgresQueryUtils.getPrimaryKeyColumnsProjection(pkRowType), PostgresQueryUtils.getMaxPrimaryKeyColumnsProjection(pkRowType), Optional.ofNullable(condition), orderBy);
    }

    public static PreparedStatement readTableSplitDataStatement(JdbcConnection jdbc, String sql, boolean isFirstSplit, boolean isLastSplit, Object[] splitStart, Object[] splitEnd, int primaryKeyNum, int fetchSize) {
        try {
            PreparedStatement statement = PostgresQueryUtils.initStatement(jdbc, sql, fetchSize);
            if (isFirstSplit && isLastSplit) {
                return statement;
            }
            if (isFirstSplit) {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitEnd[i]);
                    statement.setObject(i + 1 + primaryKeyNum, splitEnd[i]);
                }
            } else if (isLastSplit) {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitStart[i]);
                }
            } else {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitStart[i]);
                    statement.setObject(i + 1 + primaryKeyNum, splitEnd[i]);
                    statement.setObject(i + 1 + 2 * primaryKeyNum, splitEnd[i]);
                }
            }
            return statement;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build the split data read statement.", e);
        }
    }

    public static String quote(String name) {
        return "\"" + name.replace("\"", "\"\"") + "\"";
    }

    private static String quoteForMinMax(Column column) {
        String quoteColumn = PostgresQueryUtils.quote(column.name());
        return PostgresQueryUtils.isUUID(column) ? PostgresQueryUtils.castToText(quoteColumn) : quoteColumn;
    }

    private static String castParam(Column column) {
        return PostgresQueryUtils.castParam(PostgresQueryUtils.isUUID(column));
    }

    private static String castParam(boolean isUUID) {
        return isUUID ? PostgresQueryUtils.castToUuid("?") : "?";
    }

    private static String castToUuid(String value) {
        return String.format("(%s)::uuid", value);
    }

    private static String castToText(String value) {
        return String.format("(%s)::text", value);
    }

    public static boolean isUUID(Column column) {
        return column.typeName().equals("uuid");
    }

    public static String quote(TableId tableId) {
        return tableId.toQuotedString('\"');
    }

    private static PreparedStatement initStatement(JdbcConnection jdbc, String sql, int fetchSize) throws SQLException {
        Connection connection = jdbc.connection();
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(fetchSize);
        return statement;
    }

    private static void addPrimaryKeyColumnsToCondition(RowType pkRowType, StringBuilder sql, String predicate, List<String> uuidFields) {
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            String fieldName = (String)fieldNamesIt.next();
            boolean isUUID = uuidFields.contains(fieldName);
            sql.append(PostgresQueryUtils.quote(fieldName)).append(predicate).append(PostgresQueryUtils.castParam(isUUID));
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" AND ");
        }
    }

    private static String getPrimaryKeyColumnsProjection(RowType pkRowType) {
        StringBuilder sql = new StringBuilder();
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append(PostgresQueryUtils.quote((String)fieldNamesIt.next()));
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" , ");
        }
        return sql.toString();
    }

    private static String getMaxPrimaryKeyColumnsProjection(RowType pkRowType) {
        StringBuilder sql = new StringBuilder();
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append("MAX(" + PostgresQueryUtils.quote((String)fieldNamesIt.next()) + ")");
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" , ");
        }
        return sql.toString();
    }

    private static String buildSelectWithRowLimits(TableId tableId, int limit, String projection, Optional<String> condition, Optional<String> orderBy) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(projection).append(" FROM ");
        sql.append(PostgresQueryUtils.quote(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        if (orderBy.isPresent()) {
            sql.append(" ORDER BY ").append(orderBy.get());
        }
        if (limit > 0) {
            sql.append(" LIMIT ").append(limit);
        }
        return sql.toString();
    }

    private static String buildSelectWithBoundaryRowLimits(TableId tableId, int limit, String projection, String maxColumnProjection, Optional<String> condition, String orderBy) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(maxColumnProjection);
        sql.append(" FROM (");
        sql.append("SELECT ");
        sql.append(projection);
        sql.append(" FROM ");
        sql.append(PostgresQueryUtils.quote(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        sql.append(" ORDER BY ").append(orderBy).append(" LIMIT ").append(limit);
        sql.append(") T");
        return sql.toString();
    }
}

