/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source.offset;

import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.time.Conversions;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresOffset
extends Offset {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresOffset.class);
    public static final PostgresOffset INITIAL_OFFSET = new PostgresOffset(Lsn.INVALID_LSN.asLong(), null, Instant.MIN);
    public static final PostgresOffset NO_STOPPING_OFFSET = new PostgresOffset(Lsn.NO_STOPPING_LSN.asLong(), null, Instant.MAX);

    PostgresOffset(Map<String, String> offset) {
        this.offset = offset;
    }

    PostgresOffset(Long lsn, Long txId, Instant lastCommitTs) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put("lsn", lsn.toString());
        if (txId != null) {
            offsetMap.put("txId", txId.toString());
        }
        if (lastCommitTs != null) {
            offsetMap.put("ts_usec", String.valueOf(Conversions.toEpochMicros(lastCommitTs)));
        }
        this.offset = offsetMap;
    }

    public static PostgresOffset of(SourceRecord dataRecord) {
        return PostgresOffset.of(dataRecord.sourceOffset());
    }

    public static PostgresOffset of(Map<String, ?> offsetMap) {
        HashMap<String, String> offsetStrMap = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : offsetMap.entrySet()) {
            offsetStrMap.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        return new PostgresOffset(offsetStrMap);
    }

    public Lsn getLsn() {
        return Lsn.valueOf(Long.valueOf((String)this.offset.get("lsn")));
    }

    @Nullable
    public Long getTxid() {
        String txid = (String)this.offset.get("txId");
        return txid == null ? null : Long.valueOf(txid);
    }

    @Nullable
    public Long getLastCommitTs() {
        String lastCommitTs = (String)this.offset.get("ts_usec");
        return lastCommitTs == null ? null : Long.valueOf(lastCommitTs);
    }

    @Override
    public int compareTo(Offset o) {
        PostgresOffset rhs = (PostgresOffset)o;
        LOG.debug("comparing {} and {}", (Object)this, (Object)rhs);
        return this.getLsn().compareTo(rhs.getLsn());
    }

    @Override
    public String toString() {
        return "Offset{lsn=" + this.getLsn() + ", txId=" + (this.getTxid() == null ? "null" : this.getTxid()) + ", lastCommitTs=" + (this.getLastCommitTs() == null ? "null" : this.getLastCommitTs()) + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostgresOffset)) {
            return false;
        }
        PostgresOffset that = (PostgresOffset)o;
        return this.offset.equals(that.offset);
    }

    @Override
    public Map<String, String> getOffset() {
        return this.offset;
    }
}

