/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.meta.split;

import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.split.SchemalessSnapshotSplit;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.table.types.logical.RowType;

public class SnapshotSplit
extends SourceSplitBase {
    private final TableId tableId;
    private final RowType splitKeyType;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;
    @Nullable
    private final Object[] splitStart;
    @Nullable
    private final Object[] splitEnd;
    @Nullable
    private final Offset highWatermark;
    @Nullable
    transient byte[] serializedFormCache;

    public SnapshotSplit(TableId tableId, int chunkId, RowType splitKeyType, Object[] splitStart, Object[] splitEnd, Offset highWatermark, Map<TableId, TableChanges.TableChange> tableSchemas) {
        super(SnapshotSplit.generateSplitId(tableId, chunkId));
        this.tableId = tableId;
        this.splitKeyType = splitKeyType;
        this.splitStart = splitStart;
        this.splitEnd = splitEnd;
        this.highWatermark = highWatermark;
        this.tableSchemas = tableSchemas;
    }

    @Internal
    public SnapshotSplit(TableId tableId, String splitId, RowType splitKeyType, Object[] splitStart, Object[] splitEnd, Offset highWatermark, Map<TableId, TableChanges.TableChange> tableSchemas) {
        super(splitId);
        this.tableId = tableId;
        this.splitKeyType = splitKeyType;
        this.splitStart = splitStart;
        this.splitEnd = splitEnd;
        this.highWatermark = highWatermark;
        this.tableSchemas = tableSchemas;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    @Nullable
    public Object[] getSplitStart() {
        return this.splitStart;
    }

    @Nullable
    public Object[] getSplitEnd() {
        return this.splitEnd;
    }

    @Nullable
    public Offset getHighWatermark() {
        return this.highWatermark;
    }

    public boolean isSnapshotReadFinished() {
        return this.highWatermark != null;
    }

    @Override
    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public final SchemalessSnapshotSplit toSchemalessSnapshotSplit() {
        return new SchemalessSnapshotSplit(this.tableId, this.splitId, this.splitKeyType, this.splitStart, this.splitEnd, this.highWatermark);
    }

    public static String generateSplitId(TableId tableId, int chunkId) {
        return tableId.toString() + ":" + chunkId;
    }

    public static TableId extractTableId(String splitId) {
        return TableId.parse(splitId.substring(0, splitId.lastIndexOf(":")));
    }

    public static int extractChunkId(String splitId) {
        return Integer.parseInt(splitId.substring(splitId.lastIndexOf(":") + 1));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SnapshotSplit that = (SnapshotSplit)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.splitKeyType, that.splitKeyType) && Arrays.equals(this.splitStart, that.splitStart) && Arrays.equals(this.splitEnd, that.splitEnd) && Objects.equals(this.highWatermark, that.highWatermark);
    }

    public RowType getSplitKeyType() {
        return this.splitKeyType;
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.tableId, this.splitKeyType, this.highWatermark);
        result = 31 * result + Arrays.hashCode(this.splitStart);
        result = 31 * result + Arrays.hashCode(this.splitEnd);
        result = 31 * result + Arrays.hashCode(this.serializedFormCache);
        return result;
    }

    public String toString() {
        String splitKeyTypeSummary = this.splitKeyType.getFields().stream().map(RowType.RowField::asSummaryString).collect(Collectors.joining(",", "[", "]"));
        return "SnapshotSplit{tableId=" + this.tableId + ", splitId='" + this.splitId + '\'' + ", splitKeyType=" + splitKeyTypeSummary + ", splitStart=" + Arrays.toString(this.splitStart) + ", splitEnd=" + Arrays.toString(this.splitEnd) + ", highWatermark=" + this.highWatermark + '}';
    }
}

