/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.connection;

import com.oceanbase.clogproxy.client.config.ClientConf;
import com.oceanbase.clogproxy.client.connection.ClientStream;
import com.oceanbase.clogproxy.client.connection.ConnectionParams;
import com.oceanbase.clogproxy.common.packet.HeaderType;
import com.oceanbase.clogproxy.common.packet.protocol.LogProxyProto;
import com.oceanbase.oms.logmessage.LogMessage;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class StreamContext {
    private final BlockingQueue<TransferPacket> recordQueue;
    private final ClientStream stream;
    private final ClientConf config;
    private final ConnectionParams params;

    public StreamContext(ClientStream stream, ClientConf config, ConnectionParams params) {
        this.stream = Objects.requireNonNull(stream);
        this.config = Objects.requireNonNull(config);
        this.params = Objects.requireNonNull(params);
        this.recordQueue = new LinkedBlockingQueue<TransferPacket>(config.getTransferQueueSize());
    }

    public ConnectionParams params() {
        return this.params;
    }

    public ClientConf config() {
        return this.config;
    }

    public ClientStream stream() {
        return this.stream;
    }

    public BlockingQueue<TransferPacket> recordQueue() {
        return this.recordQueue;
    }

    public static class TransferPacket {
        protected final HeaderType type;
        protected LogMessage record;
        protected LogProxyProto.RuntimeStatus status;

        public TransferPacket(LogMessage record) {
            this.type = HeaderType.DATA_CLIENT;
            this.record = record;
        }

        public TransferPacket(LogProxyProto.RuntimeStatus status) {
            this.type = HeaderType.STATUS;
            this.status = status;
        }

        public HeaderType getType() {
            return this.type;
        }

        public LogMessage getRecord() {
            return this.record;
        }

        public LogProxyProto.RuntimeStatus getStatus() {
            return this.status;
        }
    }
}

