/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.reader;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.mysql.debezium.reader.BinlogSplitReader;
import org.apache.flink.cdc.connectors.mysql.debezium.reader.DebeziumReader;
import org.apache.flink.cdc.connectors.mysql.debezium.reader.SnapshotSplitReader;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.reader.MySqlSourceReaderContext;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlRecords;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSnapshotSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.SourceRecords;
import org.apache.flink.cdc.connectors.mysql.source.utils.hooks.SnapshotPhaseHooks;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsAddition;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSplitReader
implements SplitReader<SourceRecords, MySqlSplit> {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSplitReader.class);
    private final ArrayDeque<MySqlSnapshotSplit> snapshotSplits;
    private final ArrayDeque<MySqlBinlogSplit> binlogSplits;
    private final MySqlSourceConfig sourceConfig;
    private final int subtaskId;
    private final MySqlSourceReaderContext context;
    private final SnapshotPhaseHooks snapshotHooks;
    @Nullable
    private String currentSplitId;
    @Nullable
    private DebeziumReader<SourceRecords, MySqlSplit> currentReader;
    @Nullable
    private SnapshotSplitReader reusedSnapshotReader;
    @Nullable
    private BinlogSplitReader reusedBinlogReader;

    public MySqlSplitReader(MySqlSourceConfig sourceConfig, int subtaskId, MySqlSourceReaderContext context, SnapshotPhaseHooks snapshotHooks) {
        this.sourceConfig = sourceConfig;
        this.subtaskId = subtaskId;
        this.snapshotSplits = new ArrayDeque();
        this.binlogSplits = new ArrayDeque(1);
        this.context = context;
        this.snapshotHooks = snapshotHooks;
    }

    public RecordsWithSplitIds<SourceRecords> fetch() throws IOException {
        try {
            this.suspendBinlogReaderIfNeed();
            return this.pollSplitRecords();
        }
        catch (InterruptedException e) {
            LOG.warn("fetch data failed.", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void suspendBinlogReaderIfNeed() {
        if (this.currentReader != null && this.currentReader instanceof BinlogSplitReader && this.context.isBinlogSplitReaderSuspended() && !this.currentReader.isFinished()) {
            ((BinlogSplitReader)this.currentReader).stopBinlogReadTask();
            LOG.info("Suspend binlog reader to wait the binlog split update.");
        }
    }

    private MySqlRecords pollSplitRecords() throws InterruptedException {
        if (this.currentReader == null) {
            if (!this.binlogSplits.isEmpty()) {
                MySqlSplit nextSplit = this.binlogSplits.poll();
                this.currentSplitId = nextSplit.splitId();
                this.currentReader = this.getBinlogSplitReader();
                this.currentReader.submitSplit(nextSplit);
            } else if (!this.snapshotSplits.isEmpty()) {
                MySqlSplit nextSplit = this.snapshotSplits.poll();
                this.currentSplitId = nextSplit.splitId();
                this.currentReader = this.getSnapshotSplitReader();
                this.currentReader.submitSplit(nextSplit);
            } else {
                LOG.info("No available split to read.");
            }
            Iterator<SourceRecords> dataIt = this.currentReader.pollSplitRecords();
            return dataIt == null ? this.finishedSplit(true) : this.forUnfinishedRecords(dataIt);
        }
        if (this.currentReader instanceof SnapshotSplitReader) {
            MySqlRecords finishedRecords;
            Iterator<SourceRecords> dataIt = this.currentReader.pollSplitRecords();
            if (dataIt != null) {
                return this.forUnfinishedRecords(dataIt);
            }
            if (this.context.isHasAssignedBinlogSplit()) {
                finishedRecords = this.forNewAddedTableFinishedSplit(this.currentSplitId);
                this.closeSnapshotReader();
                this.closeBinlogReader();
            } else {
                finishedRecords = this.finishedSplit(false);
                MySqlSplit nextSplit = this.snapshotSplits.poll();
                if (nextSplit != null) {
                    this.currentSplitId = nextSplit.splitId();
                    this.currentReader.submitSplit(nextSplit);
                } else {
                    this.closeSnapshotReader();
                }
            }
            return finishedRecords;
        }
        if (this.currentReader instanceof BinlogSplitReader) {
            Iterator<SourceRecords> dataIt = this.currentReader.pollSplitRecords();
            if (dataIt != null) {
                MySqlSplit nextSplit = this.snapshotSplits.poll();
                if (nextSplit != null) {
                    this.closeBinlogReader();
                    LOG.info("It's turn to switch next fetch reader to snapshot split reader");
                    this.currentSplitId = nextSplit.splitId();
                    this.currentReader = this.getSnapshotSplitReader();
                    this.currentReader.submitSplit(nextSplit);
                }
                return MySqlRecords.forUnfinishedRecords("binlog-split", dataIt);
            }
            this.closeBinlogReader();
            return this.finishedSplit(true);
        }
        throw new IllegalStateException("Unsupported reader type.");
    }

    private MySqlRecords finishedSplit(boolean recycleScanFetcher) {
        MySqlRecords finishedRecords = MySqlRecords.forFinishedSplit(this.currentSplitId);
        if (recycleScanFetcher) {
            this.closeSnapshotReader();
        }
        this.currentSplitId = null;
        return finishedRecords;
    }

    private MySqlRecords forUnfinishedRecords(Iterator<SourceRecords> dataIt) {
        return MySqlRecords.forUnfinishedRecords(this.currentSplitId, dataIt);
    }

    private MySqlRecords forNewAddedTableFinishedSplit(String splitId) {
        HashSet<String> finishedSplits = new HashSet<String>();
        finishedSplits.add(splitId);
        finishedSplits.add("binlog-split");
        this.currentSplitId = null;
        return new MySqlRecords(splitId, Collections.emptyIterator(), finishedSplits);
    }

    public void handleSplitsChanges(SplitsChange<MySqlSplit> splitsChanges) {
        if (!(splitsChanges instanceof SplitsAddition)) {
            throw new UnsupportedOperationException(String.format("The SplitChange type of %s is not supported.", splitsChanges.getClass()));
        }
        LOG.info("Handling split change {}", splitsChanges);
        for (MySqlSplit mySqlSplit : splitsChanges.splits()) {
            if (mySqlSplit.isSnapshotSplit()) {
                this.snapshotSplits.add(mySqlSplit.asSnapshotSplit());
                continue;
            }
            this.binlogSplits.add(mySqlSplit.asBinlogSplit());
        }
    }

    public void wakeUp() {
    }

    public void close() throws Exception {
        this.closeSnapshotReader();
        this.closeBinlogReader();
    }

    private SnapshotSplitReader getSnapshotSplitReader() {
        if (this.reusedSnapshotReader == null) {
            this.reusedSnapshotReader = new SnapshotSplitReader(this.sourceConfig, this.subtaskId, this.snapshotHooks);
        }
        return this.reusedSnapshotReader;
    }

    private BinlogSplitReader getBinlogSplitReader() {
        if (this.reusedBinlogReader == null) {
            this.reusedBinlogReader = new BinlogSplitReader(this.sourceConfig, this.subtaskId);
        }
        return this.reusedBinlogReader;
    }

    private void closeSnapshotReader() {
        if (this.reusedSnapshotReader != null) {
            LOG.debug("Close snapshot reader {}", (Object)this.reusedSnapshotReader.getClass().getCanonicalName());
            this.reusedSnapshotReader.close();
            if (this.reusedSnapshotReader == this.currentReader) {
                this.currentReader = null;
            }
            this.reusedSnapshotReader = null;
        }
    }

    private void closeBinlogReader() {
        if (this.reusedBinlogReader != null) {
            LOG.debug("Close binlog reader {}", (Object)this.reusedBinlogReader.getClass().getCanonicalName());
            this.reusedBinlogReader.close();
            if (this.reusedBinlogReader == this.currentReader) {
                this.currentReader = null;
            }
            this.reusedBinlogReader = null;
        }
    }
}

