/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class ListOffsetsResponse
extends AbstractResponse {
    public static final long UNKNOWN_TIMESTAMP = -1L;
    public static final long UNKNOWN_OFFSET = -1L;
    public static final int UNKNOWN_EPOCH = -1;
    private final ListOffsetsResponseData data;

    public ListOffsetsResponse(ListOffsetsResponseData data) {
        super(ApiKeys.LIST_OFFSETS);
        this.data = data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public ListOffsetsResponseData data() {
        return this.data;
    }

    public List<ListOffsetsResponseData.ListOffsetsTopicResponse> topics() {
        return this.data.topics();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.topics().forEach(topic -> topic.partitions().forEach(partition -> this.updateErrorCounts(errorCounts, Errors.forCode(partition.errorCode()))));
        return errorCounts;
    }

    public static ListOffsetsResponse parse(ByteBuffer buffer, short version) {
        return new ListOffsetsResponse(new ListOffsetsResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 3;
    }

    public static ListOffsetsResponseData.ListOffsetsTopicResponse singletonListOffsetsTopicResponse(TopicPartition tp, Errors error, long timestamp, long offset, int epoch) {
        return new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(tp.topic()).setPartitions(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(tp.partition()).setErrorCode(error.code()).setTimestamp(timestamp).setOffset(offset).setLeaderEpoch(epoch)));
    }
}

