/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.split;

import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.mysql.source.offset.BinlogOffset;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import org.apache.flink.cdc.connectors.mysql.source.split.MySqlSplitState;

public class MySqlBinlogSplitState
extends MySqlSplitState {
    @Nullable
    private BinlogOffset startingOffset;
    @Nullable
    private BinlogOffset endingOffset;
    private final Map<TableId, TableChanges.TableChange> tableSchemas;

    public MySqlBinlogSplitState(MySqlBinlogSplit split) {
        super(split);
        this.startingOffset = split.getStartingOffset();
        this.endingOffset = split.getEndingOffset();
        this.tableSchemas = split.getTableSchemas();
    }

    @Nullable
    public BinlogOffset getStartingOffset() {
        return this.startingOffset;
    }

    public void setStartingOffset(@Nullable BinlogOffset startingOffset) {
        this.startingOffset = startingOffset;
    }

    @Nullable
    public BinlogOffset getEndingOffset() {
        return this.endingOffset;
    }

    public void setEndingOffset(@Nullable BinlogOffset endingOffset) {
        this.endingOffset = endingOffset;
    }

    public Map<TableId, TableChanges.TableChange> getTableSchemas() {
        return this.tableSchemas;
    }

    public void recordSchema(TableId tableId, TableChanges.TableChange latestTableChange) {
        this.tableSchemas.put(tableId, latestTableChange);
    }

    @Override
    public MySqlBinlogSplit toMySqlSplit() {
        MySqlBinlogSplit binlogSplit = this.split.asBinlogSplit();
        return new MySqlBinlogSplit(binlogSplit.splitId(), this.getStartingOffset(), this.getEndingOffset(), binlogSplit.asBinlogSplit().getFinishedSnapshotSplitInfos(), this.getTableSchemas(), binlogSplit.getTotalFinishedSplitSize(), binlogSplit.isSuspended());
    }

    public String toString() {
        return "MySqlBinlogSplitState{startingOffset=" + this.startingOffset + ", endingOffset=" + this.endingOffset + ", split=" + this.split + '}';
    }
}

