/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.cdc.common.types.DataTypeVisitor;

@PublicEvolving
public final class VarCharType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_LENGTH = 1;
    public static final int DEFAULT_LENGTH = 1;
    public static final int MAX_LENGTH = Integer.MAX_VALUE;
    private static final String FORMAT = "VARCHAR(%d)";
    private static final String MAX_FORMAT = "STRING";
    private final int length;

    public VarCharType(boolean isNullable, int length) {
        super(isNullable, DataTypeRoot.VARCHAR);
        if (length < 1) {
            throw new IllegalArgumentException(String.format("Variable character string length must be between %d and %d (both inclusive).", 1, Integer.MAX_VALUE));
        }
        this.length = length;
    }

    public VarCharType(int length) {
        this(true, length);
    }

    public VarCharType() {
        this(1);
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new VarCharType(isNullable, this.length);
    }

    @Override
    public String asSerializableString() {
        if (this.length == Integer.MAX_VALUE) {
            return this.withNullability(MAX_FORMAT, new Object[0]);
        }
        return this.withNullability(FORMAT, this.length);
    }

    @Override
    public List<DataType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VarCharType that = (VarCharType)o;
        return this.length == that.length;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.length);
    }

    public static VarCharType stringType() {
        return new VarCharType(Integer.MAX_VALUE);
    }
}

