/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.data;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.utils.Preconditions;

@PublicEvolving
public final class LocalZonedTimestampData
implements Comparable<LocalZonedTimestampData> {
    private static final long MILLIS_PER_DAY = 86400000L;
    private final long epochMillisecond;
    private final int epochNanoOfMillisecond;

    private LocalZonedTimestampData(long epochMillisecond, int epochNanoOfMillisecond) {
        Preconditions.checkArgument(epochNanoOfMillisecond >= 0 && epochNanoOfMillisecond <= 999999);
        this.epochMillisecond = epochMillisecond;
        this.epochNanoOfMillisecond = epochNanoOfMillisecond;
    }

    public long getEpochMillisecond() {
        return this.epochMillisecond;
    }

    public int getEpochNanoOfMillisecond() {
        return this.epochNanoOfMillisecond;
    }

    public Instant toInstant() {
        long epochSecond = this.epochMillisecond / 1000L;
        int milliOfSecond = (int)(this.epochMillisecond % 1000L);
        if (milliOfSecond < 0) {
            --epochSecond;
            milliOfSecond += 1000;
        }
        long nanoAdjustment = milliOfSecond * 1000000 + this.epochNanoOfMillisecond;
        return Instant.ofEpochSecond(epochSecond, nanoAdjustment).atZone(ZoneId.of("UTC")).toInstant();
    }

    @Override
    public int compareTo(LocalZonedTimestampData that) {
        int cmp = Long.compare(this.epochMillisecond, that.epochMillisecond);
        if (cmp == 0) {
            cmp = this.epochNanoOfMillisecond - that.epochNanoOfMillisecond;
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalZonedTimestampData)) {
            return false;
        }
        LocalZonedTimestampData that = (LocalZonedTimestampData)obj;
        return this.epochMillisecond == that.epochMillisecond && this.epochNanoOfMillisecond == that.epochNanoOfMillisecond;
    }

    public int hashCode() {
        int ret = (int)this.epochMillisecond ^ (int)(this.epochMillisecond >> 32);
        return 31 * ret + this.epochNanoOfMillisecond;
    }

    public String toString() {
        return this.describeLocalZonedTimestampInUTC0().toString();
    }

    private LocalDateTime describeLocalZonedTimestampInUTC0() {
        int date = (int)(this.epochMillisecond / 86400000L);
        int time = (int)(this.epochMillisecond % 86400000L);
        if (time < 0) {
            --date;
            time = (int)((long)time + 86400000L);
        }
        long nanoOfDay = (long)time * 1000000L + (long)this.epochNanoOfMillisecond;
        LocalDate localDate = LocalDate.ofEpochDay(date);
        LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
        return LocalDateTime.of(localDate, localTime);
    }

    public static LocalZonedTimestampData fromEpochMillis(long millisecond) {
        return new LocalZonedTimestampData(millisecond, 0);
    }

    public static LocalZonedTimestampData fromEpochMillis(long millisecond, int epochNanoOfMillisecond) {
        return new LocalZonedTimestampData(millisecond, epochNanoOfMillisecond);
    }

    public static LocalZonedTimestampData fromInstant(Instant instant) {
        long epochSecond = instant.getEpochSecond();
        int nanoSecond = instant.getNano();
        long millisecond = epochSecond * 1000L + (long)(nanoSecond / 1000000);
        int nanoOfMillisecond = nanoSecond % 1000000;
        return new LocalZonedTimestampData(millisecond, nanoOfMillisecond);
    }

    public static boolean isCompact(int precision) {
        return precision <= 3;
    }
}

