/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.network.protocol;

import com.github.shyiko.mysql.binlog.io.BufferedSocketInputStream;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import com.github.shyiko.mysql.binlog.io.ByteArrayOutputStream;
import com.github.shyiko.mysql.binlog.network.IdentityVerificationException;
import com.github.shyiko.mysql.binlog.network.SSLSocketFactory;
import com.github.shyiko.mysql.binlog.network.protocol.command.Command;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.Channel;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;

public class PacketChannel
implements Channel {
    private int packetNumber = 0;
    private boolean authenticationComplete;
    private boolean isSSL = false;
    private Socket socket;
    private ByteArrayInputStream inputStream;
    private ByteArrayOutputStream outputStream;

    public PacketChannel(String hostname, int port) throws IOException {
        this(new Socket(hostname, port));
    }

    public PacketChannel(Socket socket) throws IOException {
        this.socket = socket;
        this.inputStream = new ByteArrayInputStream(new BufferedSocketInputStream(socket.getInputStream()));
        this.outputStream = new ByteArrayOutputStream(socket.getOutputStream());
    }

    public ByteArrayInputStream getInputStream() {
        return this.inputStream;
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.outputStream;
    }

    public void authenticationComplete() {
        this.authenticationComplete = true;
    }

    public byte[] read() throws IOException {
        int length = this.inputStream.readInteger(3);
        int sequence = this.inputStream.read();
        if (sequence != this.packetNumber++) {
            throw new IOException("unexpected sequence #" + sequence);
        }
        return this.inputStream.read(length);
    }

    public void write(Command command) throws IOException {
        byte[] body = command.toByteArray();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.writeInteger(body.length, 3);
        if (this.authenticationComplete) {
            this.packetNumber = 0;
        }
        buffer.writeInteger(this.packetNumber++, 1);
        buffer.write(body, 0, body.length);
        this.outputStream.write(buffer.toByteArray());
        this.outputStream.flush();
    }

    public void upgradeToSSL(SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) throws IOException {
        SSLSocket sslSocket = sslSocketFactory.createSocket(this.socket);
        sslSocket.startHandshake();
        this.socket = sslSocket;
        this.inputStream = new ByteArrayInputStream(sslSocket.getInputStream());
        this.outputStream = new ByteArrayOutputStream(sslSocket.getOutputStream());
        if (hostnameVerifier != null && !hostnameVerifier.verify(sslSocket.getInetAddress().getHostName(), sslSocket.getSession())) {
            throw new IdentityVerificationException("\"" + sslSocket.getInetAddress().getHostName() + "\" identity was not confirmed");
        }
        this.isSSL = true;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public void close() throws IOException {
        try {
            this.socket.shutdownInput();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.shutdownOutput();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }
}

