/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.writemodel.strategy;

import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategy;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class UpdateOneDefaultStrategy
implements WriteModelStrategy {
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        BsonDocument vd = document.getValueDoc().orElseThrow(() -> new DataException("Could not build the WriteModel,the value document was missing unexpectedly"));
        BsonValue idValue = vd.get("_id");
        if (idValue == null) {
            throw new DataException("Could not build the WriteModel,the `_id` field was missing unexpectedly");
        }
        vd.remove("_id");
        return new UpdateOneModel<BsonDocument>((Bson)new BsonDocument("_id", idValue), new BsonDocument("$set", vd), UPDATE_OPTIONS);
    }
}

