/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.field.renaming;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.processor.field.renaming.Renamer;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;

public class RenameByMapping
extends Renamer {
    private Map<String, String> fieldMappings = this.parseRenameFieldnameMappings();

    public RenameByMapping(MongoSinkTopicConfig config) {
        super(config);
    }

    @Override
    boolean isActive() {
        return !this.fieldMappings.isEmpty();
    }

    @Override
    String renamed(String path, String name) {
        String newName = this.fieldMappings.get(path + "." + name);
        return newName != null ? newName : name;
    }

    private Map<String, String> parseRenameFieldnameMappings() {
        String settings = this.getConfig().getString("field.renamer.mapping");
        HashMap<String, String> map = new HashMap<String, String>();
        ConfigHelper.jsonArrayFromString(settings).ifPresent(renames -> {
            for (Document r : renames) {
                if (!r.containsKey("oldName") && !r.containsKey("newName")) {
                    throw new ConnectConfigException("field.renamer.mapping", settings, "Both oldName and newName must be mapped");
                }
                map.put(r.getString("oldName"), r.getString("newName"));
            }
        });
        return map;
    }
}

