/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.config;

import com.mongodb.lang.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import org.bson.BsonTimestamp;
import org.bson.json.JsonReader;
import org.slf4j.Logger;

public final class BsonTimestampParser {
    public static final String FORMAT_DESCRIPTION = "Must be either an integer number of seconds since the Epoch in the decimal format (example: 30), or an instant in the ISO-8601 format with one second precision (example: '1970-01-01T00:00:30Z'), or a BSON Timestamp in the canonical extended JSON (v2) format (example: '{\"$timestamp\": {\"t\": 30, \"i\": 0}}').";

    public static BsonTimestamp parse(String propertyName, String propertyValue, @Nullable Logger logger) throws ConfigException {
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        try {
            return new BsonTimestamp(Integer.parseInt(propertyValue), 0);
        }
        catch (RuntimeException e) {
            exceptions.add(e);
            try {
                Instant instant = Instant.parse(propertyValue);
                if (logger != null && instant.getNano() > 0) {
                    logger.warn("Trimmed the value {} of `{}` to seconds.", (Object)propertyValue, (Object)propertyName);
                }
                return new BsonTimestamp(Math.toIntExact(instant.getEpochSecond()), 0);
            }
            catch (RuntimeException e2) {
                BsonTimestamp bsonTimestamp;
                exceptions.add(e2);
                JsonReader jsonReader = new JsonReader(propertyValue);
                try {
                    bsonTimestamp = jsonReader.readTimestamp();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e3) {
                        exceptions.add(e3);
                        ConfigException configException = new ConfigException(propertyName, propertyValue, FORMAT_DESCRIPTION);
                        exceptions.forEach(configException::addSuppressed);
                        throw configException;
                    }
                }
                jsonReader.close();
                return bsonTimestamp;
            }
        }
    }

    private BsonTimestampParser() {
    }
}

