/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackLoop;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.LoopState;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.async.function.RetryingAsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryingSyncSupplier;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.BulkWriteBatch;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.operation.retry.AttachmentKeys;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;

public class MixedBulkWriteOperation
implements AsyncWriteOperation<BulkWriteResult>,
WriteOperation<BulkWriteResult> {
    private static final FieldNameValidator NO_OP_FIELD_NAME_VALIDATOR = new NoOpFieldNameValidator();
    private final MongoNamespace namespace;
    private final List<? extends WriteRequest> writeRequests;
    private final boolean ordered;
    private final boolean retryWrites;
    private final WriteConcern writeConcern;
    private Boolean bypassDocumentValidation;
    private BsonValue comment;
    private BsonDocument variables;

    public MixedBulkWriteOperation(MongoNamespace namespace, List<? extends WriteRequest> writeRequests, boolean ordered, WriteConcern writeConcern, boolean retryWrites) {
        this.ordered = ordered;
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeRequests = Assertions.notNull("writes", writeRequests);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        Assertions.isTrueArgument("writes is not an empty list", !writeRequests.isEmpty());
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public List<? extends WriteRequest> getWriteRequests() {
        return this.writeRequests;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public MixedBulkWriteOperation bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public MixedBulkWriteOperation comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public MixedBulkWriteOperation let(@Nullable BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    public Boolean getRetryWrites() {
        return this.retryWrites;
    }

    private <R> Supplier<R> decorateWriteWithRetries(RetryState retryState, Supplier<R> writeFunction) {
        return new RetryingSyncSupplier<R>(retryState, CommandOperationHelper::chooseRetryableWriteException, this::shouldAttemptToRetryWrite, writeFunction);
    }

    private <R> AsyncCallbackSupplier<R> decorateWriteWithRetries(RetryState retryState, AsyncCallbackSupplier<R> writeFunction) {
        return new RetryingAsyncCallbackSupplier<R>(retryState, CommandOperationHelper::chooseRetryableWriteException, this::shouldAttemptToRetryWrite, writeFunction);
    }

    private boolean shouldAttemptToRetryWrite(RetryState retryState, Throwable attemptFailure) {
        BulkWriteTracker bulkWriteTracker = retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail);
        if (bulkWriteTracker.lastAttempt()) {
            return false;
        }
        boolean decision = CommandOperationHelper.shouldAttemptToRetryWrite(retryState, attemptFailure);
        if (decision) {
            bulkWriteTracker.advance();
        }
        return decision;
    }

    @Override
    public BulkWriteResult execute(WriteBinding binding) {
        RetryState retryState = new RetryState();
        BulkWriteTracker.attachNew(retryState, this.retryWrites);
        Supplier<BulkWriteResult> retryingBulkWrite = this.decorateWriteWithRetries(retryState, () -> {
            CommandOperationHelper.logRetryExecute(retryState);
            return OperationHelper.withSourceAndConnection(binding::getWriteConnectionSource, true, (source, connection) -> {
                ConnectionDescription connectionDescription = connection.getDescription();
                retryState.attach(AttachmentKeys.maxWireVersion(), connectionDescription.getMaxWireVersion(), true);
                SessionContext sessionContext = binding.getSessionContext();
                WriteConcern writeConcern = this.getAppliedWriteConcern(sessionContext);
                if (!OperationHelper.isRetryableWrite(this.retryWrites, this.getAppliedWriteConcern(sessionContext), source.getServerDescription(), connectionDescription, sessionContext)) {
                    this.handleMongoWriteConcernWithResponseException(retryState, true);
                }
                OperationHelper.validateWriteRequests(connectionDescription, this.bypassDocumentValidation, this.writeRequests, writeConcern);
                if (!retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().isPresent()) {
                    BulkWriteTracker.attachNew(retryState, BulkWriteBatch.createBulkWriteBatch(this.namespace, source.getServerDescription(), connectionDescription, this.ordered, writeConcern, this.bypassDocumentValidation, this.retryWrites, this.writeRequests, sessionContext, this.comment, this.variables));
                }
                CommandOperationHelper.logRetryExecute(retryState);
                return this.executeBulkWriteBatch(retryState, binding, (Connection)connection);
            });
        });
        try {
            return retryingBulkWrite.get();
        }
        catch (MongoException e) {
            throw CommandOperationHelper.transformWriteException(e);
        }
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<BulkWriteResult> callback) {
        RetryState retryState = new RetryState();
        BulkWriteTracker.attachNew(retryState, this.retryWrites);
        binding.retain();
        AsyncCallbackSupplier<BulkWriteResult> retryingBulkWrite = this.decorateWriteWithRetries(retryState, (SingleResultCallback<R> funcCallback) -> {
            CommandOperationHelper.logRetryExecute(retryState);
            OperationHelper.withAsyncSourceAndConnection(binding::getWriteConnectionSource, true, funcCallback, (source, connection, releasingCallback) -> {
                ConnectionDescription connectionDescription = connection.getDescription();
                retryState.attach(AttachmentKeys.maxWireVersion(), connectionDescription.getMaxWireVersion(), true);
                SessionContext sessionContext = binding.getSessionContext();
                WriteConcern writeConcern = this.getAppliedWriteConcern(sessionContext);
                if (!OperationHelper.isRetryableWrite(this.retryWrites, this.getAppliedWriteConcern(sessionContext), source.getServerDescription(), connectionDescription, sessionContext) && this.handleMongoWriteConcernWithResponseExceptionAsync(retryState, releasingCallback)) {
                    return;
                }
                if (OperationHelper.validateWriteRequestsAndCompleteIfInvalid(connectionDescription, this.bypassDocumentValidation, this.writeRequests, writeConcern, releasingCallback)) {
                    return;
                }
                try {
                    if (!retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().isPresent()) {
                        BulkWriteTracker.attachNew(retryState, BulkWriteBatch.createBulkWriteBatch(this.namespace, source.getServerDescription(), connectionDescription, this.ordered, writeConcern, this.bypassDocumentValidation, this.retryWrites, this.writeRequests, sessionContext, this.comment, this.variables));
                    }
                }
                catch (Throwable t) {
                    releasingCallback.onResult(null, t);
                    return;
                }
                CommandOperationHelper.logRetryExecute(retryState);
                this.executeBulkWriteBatchAsync(retryState, binding, (AsyncConnection)connection, releasingCallback);
            });
        }).whenComplete(binding::release);
        retryingBulkWrite.get(CommandOperationHelper.exceptionTransformingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER)));
    }

    private BulkWriteResult executeBulkWriteBatch(RetryState retryState, WriteBinding binding, Connection connection) {
        BulkWriteTracker currentBulkWriteTracker = retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail);
        BulkWriteBatch currentBatch = currentBulkWriteTracker.batch().orElseThrow(Assertions::fail);
        int maxWireVersion = connection.getDescription().getMaxWireVersion();
        while (currentBatch.shouldProcessBatch()) {
            try {
                MongoException writeConcernBasedError;
                BsonDocument result = this.executeCommand(connection, currentBatch, binding);
                if (currentBatch.getRetryWrites() && !binding.getSessionContext().hasActiveTransaction() && (writeConcernBasedError = ProtocolHelper.createSpecialException(result, connection.getDescription().getServerAddress(), "errMsg")) != null) {
                    if (currentBulkWriteTracker.lastAttempt()) {
                        CommandOperationHelper.addRetryableWriteErrorLabel(writeConcernBasedError, maxWireVersion);
                        this.addErrorLabelsToWriteConcern(result.getDocument("writeConcernError"), writeConcernBasedError.getErrorLabels());
                    } else if (CommandOperationHelper.shouldAttemptToRetryWrite(retryState, writeConcernBasedError)) {
                        throw new MongoWriteConcernWithResponseException(writeConcernBasedError, result);
                    }
                }
                currentBatch.addResult(result);
                currentBulkWriteTracker = BulkWriteTracker.attachNext(retryState, currentBatch);
                currentBatch = currentBulkWriteTracker.batch().orElseThrow(Assertions::fail);
            }
            catch (MongoException exception) {
                if (!retryState.isFirstAttempt() && !(exception instanceof MongoWriteConcernWithResponseException)) {
                    CommandOperationHelper.addRetryableWriteErrorLabel(exception, maxWireVersion);
                }
                this.handleMongoWriteConcernWithResponseException(retryState, false);
                throw exception;
            }
        }
        try {
            return currentBatch.getResult();
        }
        catch (MongoException e) {
            retryState.markAsLastAttempt();
            throw e;
        }
    }

    private void executeBulkWriteBatchAsync(RetryState retryState, AsyncWriteBinding binding, AsyncConnection connection, SingleResultCallback<BulkWriteResult> callback) {
        LoopState loopState = new LoopState();
        AsyncCallbackLoop loop = new AsyncCallbackLoop(loopState, iterationCallback -> {
            BulkWriteTracker currentBulkWriteTracker = retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail);
            loopState.attach(AttachmentKeys.bulkWriteTracker(), currentBulkWriteTracker, true);
            BulkWriteBatch currentBatch = currentBulkWriteTracker.batch().orElseThrow(Assertions::fail);
            int maxWireVersion = connection.getDescription().getMaxWireVersion();
            if (loopState.breakAndCompleteIf(() -> !currentBatch.shouldProcessBatch(), iterationCallback)) {
                return;
            }
            this.executeCommandAsync(binding, connection, currentBatch, (result, t) -> {
                if (t == null) {
                    MongoException writeConcernBasedError;
                    if (currentBatch.getRetryWrites() && !binding.getSessionContext().hasActiveTransaction() && (writeConcernBasedError = ProtocolHelper.createSpecialException(result, connection.getDescription().getServerAddress(), "errMsg")) != null) {
                        if (currentBulkWriteTracker.lastAttempt()) {
                            CommandOperationHelper.addRetryableWriteErrorLabel(writeConcernBasedError, maxWireVersion);
                            this.addErrorLabelsToWriteConcern(result.getDocument("writeConcernError"), writeConcernBasedError.getErrorLabels());
                        } else if (CommandOperationHelper.shouldAttemptToRetryWrite(retryState, writeConcernBasedError)) {
                            iterationCallback.onResult(null, new MongoWriteConcernWithResponseException(writeConcernBasedError, result));
                            return;
                        }
                    }
                    currentBatch.addResult((BsonDocument)result);
                    BulkWriteTracker.attachNext(retryState, currentBatch);
                    iterationCallback.onResult(null, null);
                } else {
                    if (t instanceof MongoException) {
                        MongoException exception = (MongoException)t;
                        if (!retryState.isFirstAttempt() && !(exception instanceof MongoWriteConcernWithResponseException)) {
                            CommandOperationHelper.addRetryableWriteErrorLabel(exception, maxWireVersion);
                        }
                        if (this.handleMongoWriteConcernWithResponseExceptionAsync(retryState, null)) {
                            return;
                        }
                    }
                    iterationCallback.onResult(null, t);
                }
            });
        });
        loop.run((voidResult, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                BulkWriteResult result;
                try {
                    result = ((BulkWriteBatch)loopState.attachment(AttachmentKeys.bulkWriteTracker()).flatMap(BulkWriteTracker::batch).orElseThrow(Assertions::fail)).getResult();
                }
                catch (Throwable loopResultT) {
                    if (loopResultT instanceof MongoException) {
                        retryState.markAsLastAttempt();
                    }
                    callback.onResult(null, loopResultT);
                    return;
                }
                callback.onResult(result, null);
            }
        });
    }

    private void handleMongoWriteConcernWithResponseException(RetryState retryState, boolean breakAndThrowIfDifferent) {
        if (!retryState.isFirstAttempt()) {
            RuntimeException prospectiveFailedResult = retryState.exception().orElse(null);
            boolean prospectiveResultIsWriteConcernException = prospectiveFailedResult instanceof MongoWriteConcernWithResponseException;
            retryState.breakAndThrowIfRetryAnd(() -> breakAndThrowIfDifferent && !prospectiveResultIsWriteConcernException);
            if (prospectiveResultIsWriteConcernException) {
                retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().ifPresent(bulkWriteBatch -> {
                    bulkWriteBatch.addResult((BsonDocument)((MongoWriteConcernWithResponseException)prospectiveFailedResult).getResponse());
                    BulkWriteTracker.attachNext(retryState, bulkWriteBatch);
                });
            }
        }
    }

    private boolean handleMongoWriteConcernWithResponseExceptionAsync(RetryState retryState, @Nullable SingleResultCallback<BulkWriteResult> callback) {
        if (!retryState.isFirstAttempt()) {
            RuntimeException prospectiveFailedResult = retryState.exception().orElse(null);
            boolean prospectiveResultIsWriteConcernException = prospectiveFailedResult instanceof MongoWriteConcernWithResponseException;
            if (callback != null && retryState.breakAndCompleteIfRetryAnd(() -> !prospectiveResultIsWriteConcernException, callback)) {
                return true;
            }
            if (prospectiveResultIsWriteConcernException) {
                retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().ifPresent(bulkWriteBatch -> {
                    bulkWriteBatch.addResult((BsonDocument)((MongoWriteConcernWithResponseException)prospectiveFailedResult).getResponse());
                    BulkWriteTracker.attachNext(retryState, bulkWriteBatch);
                });
            }
        }
        return false;
    }

    @Nullable
    private BsonDocument executeCommand(Connection connection, BulkWriteBatch batch, WriteBinding binding) {
        return connection.command(this.namespace.getDatabaseName(), batch.getCommand(), NO_OP_FIELD_NAME_VALIDATOR, null, batch.getDecoder(), binding.getSessionContext(), binding.getServerApi(), binding.getRequestContext(), this.shouldAcknowledge(batch, binding.getSessionContext()), batch.getPayload(), batch.getFieldNameValidator());
    }

    private void executeCommandAsync(AsyncWriteBinding binding, AsyncConnection connection, BulkWriteBatch batch, SingleResultCallback<BsonDocument> callback) {
        connection.commandAsync(this.namespace.getDatabaseName(), batch.getCommand(), NO_OP_FIELD_NAME_VALIDATOR, null, batch.getDecoder(), binding.getSessionContext(), binding.getServerApi(), binding.getRequestContext(), this.shouldAcknowledge(batch, binding.getSessionContext()), batch.getPayload(), batch.getFieldNameValidator(), callback);
    }

    private WriteConcern getAppliedWriteConcern(SessionContext sessionContext) {
        if (sessionContext.hasActiveTransaction()) {
            return WriteConcern.ACKNOWLEDGED;
        }
        return this.writeConcern;
    }

    private boolean shouldAcknowledge(BulkWriteBatch batch, SessionContext sessionContext) {
        return this.ordered ? batch.hasAnotherBatch() || this.getAppliedWriteConcern(sessionContext).isAcknowledged() : this.getAppliedWriteConcern(sessionContext).isAcknowledged();
    }

    private void addErrorLabelsToWriteConcern(BsonDocument result, Set<String> errorLabels) {
        if (!result.containsKey("errorLabels")) {
            result.put("errorLabels", new BsonArray(errorLabels.stream().map(BsonString::new).collect(Collectors.toList())));
        }
    }

    public static final class BulkWriteTracker {
        private int attempt = 0;
        private final int attempts;
        @Nullable
        private final BulkWriteBatch batch;

        static void attachNew(RetryState retryState, boolean retry) {
            retryState.attach(AttachmentKeys.bulkWriteTracker(), new BulkWriteTracker(retry, null), false);
        }

        static BulkWriteTracker attachNew(RetryState retryState, BulkWriteBatch batch) {
            BulkWriteTracker tracker = new BulkWriteTracker(batch.getRetryWrites(), batch);
            BulkWriteTracker.attach(retryState, tracker);
            return tracker;
        }

        static BulkWriteTracker attachNext(RetryState retryState, BulkWriteBatch batch) {
            BulkWriteBatch nextBatch = batch.getNextBatch();
            BulkWriteTracker nextTracker = new BulkWriteTracker(nextBatch.getRetryWrites(), nextBatch);
            BulkWriteTracker.attach(retryState, nextTracker);
            return nextTracker;
        }

        private static void attach(RetryState retryState, BulkWriteTracker tracker) {
            retryState.attach(AttachmentKeys.bulkWriteTracker(), tracker, false);
            BulkWriteBatch batch = tracker.batch;
            if (batch != null) {
                retryState.attach(AttachmentKeys.retryableCommandFlag(), batch.getRetryWrites(), false).attach(AttachmentKeys.commandDescriptionSupplier(), () -> batch.getPayload().getPayloadType().toString(), false);
            }
        }

        private BulkWriteTracker(boolean retry, @Nullable BulkWriteBatch batch) {
            this.attempts = retry ? 2 : 1;
            this.batch = batch;
        }

        boolean lastAttempt() {
            return this.attempt == this.attempts - 1;
        }

        void advance() {
            Assertions.assertTrue(!this.lastAttempt());
            ++this.attempt;
        }

        Optional<BulkWriteBatch> batch() {
            return Optional.ofNullable(this.batch);
        }
    }
}

