/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.source;

import java.time.Duration;
import java.util.Properties;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;
import org.apache.flink.cdc.connectors.base.source.jdbc.JdbcIncrementalSource;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.db2.source.config.Db2SourceConfigFactory;
import org.apache.flink.cdc.connectors.db2.source.dialect.Db2Dialect;
import org.apache.flink.cdc.connectors.db2.source.offset.LsnFactory;
import org.apache.flink.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class Db2SourceBuilder<T> {
    private final Db2SourceConfigFactory configFactory = new Db2SourceConfigFactory();
    private LsnFactory offsetFactory;
    private Db2Dialect dialect;
    private DebeziumDeserializationSchema<T> deserializer;

    public Db2SourceBuilder<T> hostname(String hostname) {
        this.configFactory.hostname(hostname);
        return this;
    }

    public Db2SourceBuilder<T> port(int port) {
        this.configFactory.port(port);
        return this;
    }

    public Db2SourceBuilder<T> databaseList(String ... databaseList) {
        this.configFactory.databaseList(databaseList);
        return this;
    }

    public Db2SourceBuilder<T> tableList(String ... tableList) {
        this.configFactory.tableList(tableList);
        return this;
    }

    public Db2SourceBuilder<T> username(String username) {
        this.configFactory.username(username);
        return this;
    }

    public Db2SourceBuilder<T> password(String password) {
        this.configFactory.password(password);
        return this;
    }

    public Db2SourceBuilder<T> serverTimeZone(String timeZone) {
        this.configFactory.serverTimeZone(timeZone);
        return this;
    }

    public Db2SourceBuilder<T> splitSize(int splitSize) {
        this.configFactory.splitSize(splitSize);
        return this;
    }

    public Db2SourceBuilder<T> splitMetaGroupSize(int splitMetaGroupSize) {
        this.configFactory.splitMetaGroupSize(splitMetaGroupSize);
        return this;
    }

    public Db2SourceBuilder<T> distributionFactorUpper(double distributionFactorUpper) {
        this.configFactory.distributionFactorUpper(distributionFactorUpper);
        return this;
    }

    public Db2SourceBuilder<T> distributionFactorLower(double distributionFactorLower) {
        this.configFactory.distributionFactorLower(distributionFactorLower);
        return this;
    }

    public Db2SourceBuilder<T> fetchSize(int fetchSize) {
        this.configFactory.fetchSize(fetchSize);
        return this;
    }

    public Db2SourceBuilder<T> connectTimeout(Duration connectTimeout) {
        this.configFactory.connectTimeout(connectTimeout);
        return this;
    }

    public Db2SourceBuilder<T> connectMaxRetries(int connectMaxRetries) {
        this.configFactory.connectMaxRetries(connectMaxRetries);
        return this;
    }

    public Db2SourceBuilder<T> connectionPoolSize(int connectionPoolSize) {
        this.configFactory.connectionPoolSize(connectionPoolSize);
        return this;
    }

    public Db2SourceBuilder<T> includeSchemaChanges(boolean includeSchemaChanges) {
        this.configFactory.includeSchemaChanges(includeSchemaChanges);
        return this;
    }

    public Db2SourceBuilder<T> startupOptions(StartupOptions startupOptions) {
        this.configFactory.startupOptions(startupOptions);
        return this;
    }

    public Db2SourceBuilder<T> chunkKeyColumn(String chunkKeyColumn) {
        this.configFactory.chunkKeyColumn(chunkKeyColumn);
        return this;
    }

    public Db2SourceBuilder<T> debeziumProperties(Properties properties) {
        this.configFactory.debeziumProperties(properties);
        return this;
    }

    public Db2SourceBuilder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public Db2SourceBuilder<T> closeIdleReaders(boolean closeIdleReaders) {
        this.configFactory.closeIdleReaders(closeIdleReaders);
        return this;
    }

    public Db2SourceBuilder<T> skipSnapshotBackfill(boolean skipSnapshotBackfill) {
        this.configFactory.skipSnapshotBackfill(skipSnapshotBackfill);
        return this;
    }

    public Db2SourceBuilder<T> assignUnboundedChunkFirst(boolean assignUnboundedChunkFirst) {
        this.configFactory.assignUnboundedChunkFirst(assignUnboundedChunkFirst);
        return this;
    }

    public Db2IncrementalSource<T> build() {
        this.offsetFactory = new LsnFactory();
        this.dialect = new Db2Dialect(this.configFactory.create(0));
        return new Db2IncrementalSource(this.configFactory, (DebeziumDeserializationSchema)Preconditions.checkNotNull(this.deserializer), this.offsetFactory, this.dialect);
    }

    public static class Db2IncrementalSource<T>
    extends JdbcIncrementalSource<T> {
        public Db2IncrementalSource(Db2SourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema, LsnFactory offsetFactory, Db2Dialect dataSourceDialect) {
            super(configFactory, deserializationSchema, (OffsetFactory)offsetFactory, dataSourceDialect);
        }

        public static <T> Db2SourceBuilder<T> builder() {
            return new Db2SourceBuilder();
        }
    }
}

