/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class LongSerializer
extends TypeSerializerSingleton<Long> {
    private static final long serialVersionUID = 1L;
    public static final LongSerializer INSTANCE = new LongSerializer();
    private static final Long ZERO = 0L;

    public boolean isImmutableType() {
        return true;
    }

    public Long createInstance() {
        return ZERO;
    }

    public Long copy(Long from) {
        return from;
    }

    public Long copy(Long from, Long reuse) {
        return from;
    }

    public int getLength() {
        return 8;
    }

    public void serialize(Long record, DataOutputView target) throws IOException {
        target.writeLong(record.longValue());
    }

    public Long deserialize(DataInputView source) throws IOException {
        return source.readLong();
    }

    public Long deserialize(Long reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeLong(source.readLong());
    }

    public TypeSerializerSnapshot<Long> snapshotConfiguration() {
        return new LongSerializerSnapshot();
    }

    public static final class LongSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Long> {
        public LongSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

