/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.memory;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.metrics.Sensor;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;

public class GarbageCollectedMemoryPool
extends SimpleMemoryPool
implements AutoCloseable {
    private final ReferenceQueue<ByteBuffer> garbageCollectedBuffers = new ReferenceQueue();
    private final Map<BufferReference, BufferMetadata> buffersInFlight = new ConcurrentHashMap<BufferReference, BufferMetadata>();
    private final GarbageCollectionListener gcListener = new GarbageCollectionListener();
    private final Thread gcListenerThread = new Thread((Runnable)this.gcListener, "memory pool GC listener");
    private volatile boolean alive = true;

    public GarbageCollectedMemoryPool(long sizeBytes, int maxSingleAllocationSize, boolean strict, Sensor oomPeriodSensor) {
        super(sizeBytes, maxSingleAllocationSize, strict, oomPeriodSensor);
        this.gcListenerThread.setDaemon(true);
        this.gcListenerThread.start();
    }

    @Override
    protected void bufferToBeReturned(ByteBuffer justAllocated) {
        BufferReference ref = new BufferReference(justAllocated, this.garbageCollectedBuffers);
        BufferMetadata metadata = new BufferMetadata(justAllocated.capacity());
        if (this.buffersInFlight.put(ref, metadata) != null) {
            throw new IllegalStateException("allocated buffer identity " + ref.hashCode + " already registered as in use?!");
        }
        this.log.trace("allocated buffer of size {} and identity {}", (Object)this.sizeBytes, (Object)ref.hashCode);
    }

    @Override
    protected void bufferToBeReleased(ByteBuffer justReleased) {
        BufferReference ref = new BufferReference(justReleased);
        BufferMetadata metadata = this.buffersInFlight.remove(ref);
        if (metadata == null) {
            throw new IllegalArgumentException("returned buffer " + ref.hashCode + " was never allocated by this pool");
        }
        if (metadata.sizeBytes != justReleased.capacity()) {
            throw new IllegalStateException("buffer " + ref.hashCode + " has capacity " + justReleased.capacity() + " but recorded as " + metadata.sizeBytes);
        }
        this.log.trace("released buffer of size {} and identity {}", (Object)metadata.sizeBytes, (Object)ref.hashCode);
    }

    @Override
    public void close() {
        this.alive = false;
        this.gcListenerThread.interrupt();
    }

    @Override
    public String toString() {
        long allocated = this.sizeBytes - this.availableMemory.get();
        return "GarbageCollectedMemoryPool{" + Utils.formatBytes(allocated) + "/" + Utils.formatBytes(this.sizeBytes) + " used in " + this.buffersInFlight.size() + " buffers}";
    }

    private static final class BufferReference
    extends WeakReference<ByteBuffer> {
        private final int hashCode;

        private BufferReference(ByteBuffer referent) {
            this(referent, (ReferenceQueue<? super ByteBuffer>)null);
        }

        private BufferReference(ByteBuffer referent, ReferenceQueue<? super ByteBuffer> q) {
            super(referent, q);
            this.hashCode = System.identityHashCode(referent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BufferReference that = (BufferReference)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            ByteBuffer thisBuf = (ByteBuffer)this.get();
            if (thisBuf == null) {
                return false;
            }
            ByteBuffer thatBuf = (ByteBuffer)that.get();
            return thisBuf == thatBuf;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class BufferMetadata {
        private final int sizeBytes;

        private BufferMetadata(int sizeBytes) {
            this.sizeBytes = sizeBytes;
        }
    }

    private class GarbageCollectionListener
    implements Runnable {
        private GarbageCollectionListener() {
        }

        @Override
        public void run() {
            while (GarbageCollectedMemoryPool.this.alive) {
                try {
                    BufferReference ref = (BufferReference)GarbageCollectedMemoryPool.this.garbageCollectedBuffers.remove();
                    ref.clear();
                    BufferMetadata metadata = (BufferMetadata)GarbageCollectedMemoryPool.this.buffersInFlight.remove(ref);
                    if (metadata == null) continue;
                    GarbageCollectedMemoryPool.this.availableMemory.addAndGet(metadata.sizeBytes);
                    GarbageCollectedMemoryPool.this.log.error("Reclaimed buffer of size {} and identity {} that was not properly release()ed. This is a bug.", (Object)metadata.sizeBytes, (Object)ref.hashCode);
                }
                catch (InterruptedException e) {
                    GarbageCollectedMemoryPool.this.log.debug("interrupted", e);
                }
            }
            GarbageCollectedMemoryPool.this.log.info("GC listener shutting down");
        }
    }
}

