/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.utils;

import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeFamily;
import org.apache.flink.cdc.common.types.DataTypeRoot;

public class TypeCheckUtils {
    public static boolean isNumeric(DataType type) {
        return type.getTypeRoot().getFamilies().contains((Object)DataTypeFamily.NUMERIC);
    }

    public static boolean isTemporal(DataType type) {
        return TypeCheckUtils.isTimePoint(type);
    }

    public static boolean isTimePoint(DataType type) {
        return type.getTypeRoot().getFamilies().contains((Object)DataTypeFamily.DATETIME);
    }

    public static boolean isCharacterString(DataType type) {
        return type.getTypeRoot().getFamilies().contains((Object)DataTypeFamily.CHARACTER_STRING);
    }

    public static boolean isBinaryString(DataType type) {
        return type.getTypeRoot().getFamilies().contains((Object)DataTypeFamily.BINARY_STRING);
    }

    public static boolean isTimestamp(DataType type) {
        return type.getTypeRoot() == DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE;
    }

    public static boolean isTimestampWithTimeZone(DataType type) {
        return type.getTypeRoot() == DataTypeRoot.TIMESTAMP_WITH_TIME_ZONE;
    }

    public static boolean isTimestampWithLocalZone(DataType type) {
        return type.getTypeRoot() == DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
    }

    public static boolean isBoolean(DataType type) {
        return type.getTypeRoot() == DataTypeRoot.BOOLEAN;
    }

    public static boolean isDecimal(DataType type) {
        return type.getTypeRoot() == DataTypeRoot.DECIMAL;
    }

    public static boolean isInteger(DataType type) {
        return type.getTypeRoot() == DataTypeRoot.INTEGER;
    }

    public static boolean isLong(DataType type) {
        return type.getTypeRoot() == DataTypeRoot.BIGINT;
    }

    public static boolean isArray(DataType type) {
        return type.getTypeRoot() == DataTypeRoot.ARRAY;
    }

    public static boolean isMap(DataType type) {
        return type.getTypeRoot() == DataTypeRoot.MAP;
    }

    public static boolean isRow(DataType type) {
        return type.getTypeRoot() == DataTypeRoot.ROW;
    }

    public static boolean isComparable(DataType type) {
        return !TypeCheckUtils.isMap(type) && !TypeCheckUtils.isRow(type) && !TypeCheckUtils.isArray(type);
    }

    public static boolean isMutable(DataType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case ARRAY: 
            case MAP: 
            case ROW: {
                return true;
            }
        }
        return false;
    }

    public static boolean isReference(DataType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return false;
            }
        }
        return true;
    }
}

