/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.apache.flink.cdc.common.utils.ThreadLocalCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateTimeUtils.class);
    public static final int EPOCH_JULIAN = 2440588;
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final ThreadLocalCache<String, SimpleDateFormat> FORMATTER_CACHE = ThreadLocalCache.of(SimpleDateFormat::new);

    public static int timestampMillisToDate(long ts) {
        int days = (int)(ts / 86400000L);
        if (days < 0) {
            --days;
        }
        return days;
    }

    public static int timestampMillisToTime(long ts) {
        return (int)(ts % 86400000L);
    }

    public static int parseDate(String dateStr, String fromFormat) {
        long ts = DateTimeUtils.internalParseTimestampMillis(dateStr, fromFormat, TimeZone.getTimeZone("UTC"));
        ZoneId zoneId = ZoneId.of("UTC");
        Instant instant = Instant.ofEpochMilli(ts);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        return DateTimeUtils.ymdToUnixDate(zdt.getYear(), zdt.getMonthValue(), zdt.getDayOfMonth());
    }

    private static long internalParseTimestampMillis(String dateStr, String format, TimeZone tz) {
        SimpleDateFormat formatter = FORMATTER_CACHE.get(format);
        formatter.setTimeZone(tz);
        try {
            Date date = formatter.parse(dateStr);
            return date.getTime();
        }
        catch (ParseException e) {
            LOG.error(String.format("Exception when parsing datetime string '%s' in format '%s'", dateStr, format), e);
            return Long.MIN_VALUE;
        }
    }

    private static int ymdToUnixDate(int year, int month, int day) {
        int julian = DateTimeUtils.ymdToJulian(year, month, day);
        return julian - 2440588;
    }

    private static int ymdToJulian(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        return day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
    }
}

